theory question_81_1

imports Main

begin

typedecl entity
typedecl event

consts
  Soil :: "entity ⇒ bool"
  Nonliving :: "entity ⇒ bool"
  Environment :: "entity ⇒ bool"
  PartOf :: "entity ⇒ entity ⇒ bool"
  Usually :: "bool ⇒ bool"
  Forest :: "entity ⇒ bool"

(* Explanation 1: Soil is a nonliving thing. *)
axiomatization where
  explanation_1: "∀x. Soil x ⟶ Nonliving x"

(* Explanation 2: Soil is usually part of an environment. *)
axiomatization where
  explanation_2: "∀x y. Soil x ∧ Environment y ⟶ Usually (PartOf x y)"

(* Explanation 3: A forest is a kind of environment. *)
axiomatization where
  explanation_3: "∀x. Forest x ⟶ Environment x"

theorem hypothesis:
  assumes asm: "Soil x"
  (* Hypothesis: Soil is a nonliving part of a forest. *)
  shows "∃y. PartOf x y ∧ Forest y ∧ Nonliving x"
proof -
  from asm have "Soil x" by simp
  then have "Nonliving x" using explanation_1 by blast
  then have "∃y. PartOf x y ∧ Environment y" using explanation_2 by blast
  then obtain y where y: "PartOf x y ∧ Environment y" by blast
  have "Forest y" using explanation_3 y by blast
  have conclusion: "PartOf x y ∧ Forest y ∧ Nonliving x" using y by simp
  show ?thesis using asm conclusion by blast
qed

end
