theory question_79_2
imports Main

begin

typedecl entity
typedecl event

consts
  RoughSurface :: "entity ⇒ bool"
  IncreasedRoughness :: "entity ⇒ bool"
  Surface :: "entity ⇒ entity"
  Paper :: "entity ⇒ bool"
  Object :: "entity ⇒ bool"
  HasSurface :: "entity ⇒ entity ⇒ bool"
  RoughPaper :: "entity ⇒ bool"
  Used :: "event ⇒ entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Increases :: "event ⇒ entity ⇒ bool"
  Roughness :: "entity ⇒ entity"
  Friction :: "entity ⇒ entity ⇒ bool"
  BicycleRamp :: "entity ⇒ bool"
  Interaction :: "entity ⇒ entity ⇒ bool"
  RoughPaper_on_BicycleRamp_Increases_Friction :: "entity ⇒ event ⇒ bool"

(* Explanation 1: A rough surface is a surface with increased roughness. *)
axiomatization where
  explanation_1: "∀x. RoughSurface x ⟷ IncreasedRoughness (Surface x)"

(* Explanation 2: A paper is a type of object that has a surface. *)
axiomatization where
  explanation_2: "∀x. Paper x ⟶ (∃y. Object x ∧ HasSurface x y)"

(* Explanation 3: Using rough paper on an object increases the roughness of the object's surface. *)
axiomatization where
  explanation_3: "∀x y e1 e2. RoughPaper x ∧ Object y ∧ Used e1 x ∧ Agent e1 x ∧ Patient e1 y ⟶ (∃e2. Increases e2 (Roughness (Surface y)) ∧ Agent e2 e1 ∧ Patient e2 (Surface y))"

(* Explanation 4: Increased roughness of a surface increases friction on that surface. *)
axiomatization where
  explanation_4: "∀x e1 e2. Surface x ∧ IncreasedRoughness x ⟶ (∃e1 e2. Increases e1 x ∧ Agent e1 x ⟶ (∃e2. Increases e2 (Friction x (Surface x)) ∧ Agent e2 e1))"

(* Explanation 5: A bicycle ramp is an object that has a surface. *)
axiomatization where
  explanation_5: "∀x. BicycleRamp x ⟶ (∃y. Object x ∧ HasSurface x y)"

(* Explanation 6: Using an object on another object implies an interaction between their surfaces. *)
axiomatization where
  explanation_6: "∀x y e. Object x ∧ Object y ∧ Used e x ∧ Agent e x ∧ Patient e y ⟶ Interaction (Surface x) (Surface y)"

(* Hypothesis: Rough paper should be used on a bicycle ramp to increase friction. *)
theorem hypothesis:
  assumes asm: "RoughPaper x ∧ BicycleRamp y"
  shows "∃e. RoughPaper_on_BicycleRamp_Increases_Friction x e"
proof -
  {
    assume "RoughPaper x" and "BicycleRamp y"
    then have "Object y" and "HasSurface y (Surface y)" by (auto simp: explanation_5)
    then have "Surface y" by simp
    from this and ‹RoughPaper x›
    have "IncreasedRoughness (Surface y)"
      using explanation_3 by (auto simp: explanation_3 Used_def Agent_def Patient_def)
    then have "Increases e1 (Surface y)" and "Agent e1 (Surface y)" for e1
      using explanation_4 by (auto simp: explanation_4 Increases_def)
    then obtain e2 where "Increases e2 (Friction y (Surface y))" and "Agent e2 e1"
      using explanation_4 by (auto simp: explanation_4 Increases_def)
    then have "Used e2 x" and "Agent e2 e1" and "Patient e2 (Surface y)"
      using explanation_3 by (auto simp: explanation_3 Used_def Agent_def Patient_def)
    then have "RoughPaper_on_BicycleRamp_Increases_Friction x e2"
      using RoughPaper_on_BicycleRamp_Increases_Friction_def by blast
  }
  then show ?thesis using asm by blast
qed

definition RoughPaper_on_BicycleRamp_Increases_Friction where
  "RoughPaper_on_BicycleRamp_Increases_Friction x e ≡ RoughPaper x ∧ BicycleRamp y ∧ Used e x ∧ Agent e x ∧ Patient e y ⟶ (∃e2. Increases e2 (Friction y (Surface y)) ∧ Agent e2 e ∧ Patient e2 (Surface y))"

end
