theory question_13_2
imports Main

begin

typedecl entity
typedecl event

consts
  Liquid :: "entity ⇒ bool"
  Heating :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Adding :: "event ⇒ bool"
  Energy :: "entity ⇒ bool"
  Heat :: "entity ⇒ bool"
  Boiling :: "event ⇒ bool"
  Evaporation :: "event ⇒ bool"
  Gas :: "entity ⇒ bool"
  Water :: "entity ⇒ bool"
  Disappears :: "event ⇒ bool"
  Evaporated :: "event ⇒ bool"
  Changed :: "event ⇒ bool"
  Gone :: "entity ⇒ bool"
  Matter :: "entity ⇒ bool"
  ChangingState :: "event ⇒ bool"
  State :: "entity ⇒ entity ⇒ bool"
  Pan :: "entity ⇒ bool"

(* Explanation 1: Heating a liquid means adding heat energy to the liquid. *)
axiomatization where
  explanation_1: "∀x y e1 en. Liquid y ∧ Heating e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ (∃e2. Adding e2 ∧ Agent e2 x ∧ Patient e2 en ∧ Energy en ∧ Heat en)"

(* Explanation 2: Boiling and evaporation mean changing a liquid into a gas by adding heat energy. *)
axiomatization where
  explanation_2: "∀x y e1 e2 en. Boiling e1 ∨ Evaporation e1 ∧ Liquid y ∧ Agent e1 y ∧ Patient e1 z ∧ Gas z ⟷ (∃e2. Adding e2 ∧ Agent e2 y ∧ Patient e2 en ∧ Energy en ∧ Heat en)"

(* Explanation 3: Water is a kind of liquid. *)
axiomatization where
  explanation_3: "∀x. Water x ⟶ Liquid x"

(* Explanation 4: If a liquid disappears, then it has probably evaporated and changed into a gas. *)
axiomatization where
  explanation_4: "∀x y e1 e2. Liquid x ∧ Disappears e1 ∧ Agent e1 x ⟶ (∃e2 z. Evaporated e2 ∧ Agent e2 x ∧ Patient e2 z ∧ Gas z ∧ Changed e2 ∧ Agent e2 x ∧ Patient e2 x)"

(* Explanation 5: Disappeared is similar to gone. *)
axiomatization where
  explanation_5: "∀x. Disappeared x ⟷ Gone x"

(* Explanation 6: Heating a liquid until it is all gone is an example of matter changing state from liquid to gas. *)
axiomatization where
  explanation_6: "∀x y e1 e2. Liquid y ∧ Heating e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Gone y ⟶ (∃e2 z. Matter y ∧ ChangingState e2 ∧ Agent e2 y ∧ Patient e2 z ∧ State y z ∧ State z Gas)"

theorem hypothesis:
  assumes asm: "Pan x ∧ Water y ∧ Heating e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Gone y"
  (* Hypothesis: Heating a pan of water until the water is all gone is an example of matter changing state. *)
  shows "∃e2. Matter y ∧ ChangingState e2 ∧ Agent e2 y ∧ Patient e2 z ∧ State y z ∧ State z Gas"
proof -
  {
    assume asm: "Pan x ∧ Water y ∧ Heating e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Gone y"
    from asm have "Water y" by simp
    then have "Liquid y" using explanation_3 by blast
    from asm have "Heating e1 ∧ Agent e1 x ∧ Patient e1 y" by simp
    then obtain e2 en where e2: "Adding e2 ∧ Agent e2 x ∧ Patient e2 en ∧ Energy en ∧ Heat en" using explanation_1 by blast
    from asm have "Gone y" by simp
    then obtain e3 z where e3: "Evaporated e3 ∧ Agent e3 y ∧ Patient e3 z ∧ Gas z ∧ Changed e3 ∧ Agent e3 y ∧ Patient e3 y" using explanation_4 by blast
    from e2 and e3 have "Matter y ∧ ChangingState e3 ∧ Agent e3 y ∧ Patient e3 z ∧ State y z ∧ State z Gas" using explanation_2 and explanation_6 by blast
  }
  then show ?thesis using asm by blast
qed

end
