theory question_91_6

imports Main

begin

typedecl entity
typedecl event

consts
  Bears :: "entity ⇒ bool"
  Hibernate :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Winter :: "entity ⇒ bool"
  EnergyConservation :: "event ⇒ entity ⇒ bool"
  Method :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Bears hibernate during the winter as a method to conserve their energy. *)
axiomatization where
  explanation_1: "∀x e w. Bears x ∧ Hibernate e ∧ Agent e x ∧ Winter w ⟶ EnergyConservation e x"

(* Explanation 2: Hibernation is a specific method used by bears to conserve energy. *)
axiomatization where
  explanation_2: "∀x h. Hibernate h ∧ Bears x ⟶ Method h x ∧ EnergyConservation h x"

theorem hypothesis:
  assumes asm: "Bears x ∧ Hibernate e ∧ Agent e x"
  (* Hypothesis: Bears hibernate to conserve energy. *)
  shows "EnergyConservation e x"
proof -
  from asm have "Bears x ∧ Hibernate e ∧ Agent e x" by simp
  then have "EnergyConservation e x" using explanation_1 explanation_2 by blast
  show ?thesis using asm by blast
qed

end
