theory question_85_4
imports Main

begin

typedecl entity
typedecl event

consts
  PressureReceptors :: "entity ⇒ bool"
  MainlyFoundIn :: "entity ⇒ entity ⇒ bool"
  PacinianCorpuscles :: "entity ⇒ bool"
  LocationProperty :: "(entity ⇒ bool) ⇒ entity ⇒ bool"
  Skin :: entity

(* Explanation 1: Pressure receptors are found mainly in the skin. *)
axiomatization where
  explanation_1: "∀x. PressureReceptors x ⟶ MainlyFoundIn x Skin"

(* Explanation 2: Pacinian corpuscles are a specific type of pressure receptors and share all the location properties of pressure receptors. *)
axiomatization where
  explanation_2: "∀x. PacinianCorpuscles x ⟹ (PressureReceptors x ∧ [∀y. LocationProperty y ⟹ (LocationProperty y x ⟷ LocationProperty y PressureReceptors)])"

(* Explanation 3: If an entity shares all the location properties of pressure receptors, then it is mainly found in the skin. *)
axiomatization where
  explanation_3: "∀x. ([∀y. LocationProperty y ⟹ (LocationProperty y x ⟷ LocationProperty y PressureReceptors)]) ⟹ MainlyFoundIn x Skin"

theorem hypothesis:
  assumes asm: "PacinianCorpuscles x"
  (* Hypothesis: Pacinian corpuscles are found mainly in the skin. *)
  shows "MainlyFoundIn x Skin"
proof -
  have "PacinianCorpuscles x" by fact
  then obtain p where p: "PressureReceptors x ∧ [∀y. LocationProperty y ⟹ (LocationProperty y x ⟷ LocationProperty y PressureReceptors)]" using explanation_2 by blast
  then have "MainlyFoundIn x Skin" using explanation_3 p by blast
  show ?thesis using asm p by blast
qed

end
