theory question_81_2

imports Main

begin

typedecl entity
typedecl event

consts
  ExternalMigration :: "entity ⇒ bool"
  Entity :: "entity ⇒ bool"
  PopulationSize :: "entity ⇒ bool"
  Cause :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Reduce :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Sudden :: "event ⇒ bool"
  BottleneckEffect :: "event ⇒ bool"
  Occur :: "event ⇒ bool"
  NecessaryCondition :: "event ⇒ event ⇒ bool"

(* Explanation 1: External migration can cause a sudden reduction in the population size of a specific entity. *)
axiomatization where
  explanation_1: "∀x y e1 e2. ExternalMigration x ∧ Entity y ∧ PopulationSize y ⟶ (∃e1. Cause e1 ∧ Agent e1 x) ∧ (∃e2. Reduce e2 ∧ Agent e2 x ∧ Patient e2 y ∧ Sudden e2)"

(* Explanation 2: A sudden reduction in the population size of a specific entity is a necessary condition for the bottleneck effect to occur in that entity. *)
axiomatization where
  explanation_2: "∀x y e1 e2. Entity x ∧ PopulationSize y ∧ Reduce e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Sudden e1 ⟶ (∃e2. BottleneckEffect e2 ∧ Occur e2 ∧ Agent e2 x ∧ NecessaryCondition e1 e2)"

theorem hypothesis:
  assumes asm: "ExternalMigration x"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
  shows "∃e. BottleneckEffect e ∧ Occur e ∧ Agent e x"
proof -
  from asm have "ExternalMigration x" by simp
  then obtain e1 where e1: "Cause e1 ∧ Agent e1 x" using explanation_1 by blast
  then obtain y e2 where e2: "Reduce e2 ∧ Agent e2 x ∧ Patient e2 y ∧ Sudden e2" using explanation_1 by blast
  then have "Entity y" and "PopulationSize y" by auto
  then have "BottleneckEffect e3 ∧ Occur e3 ∧ Agent e3 x" using explanation_2 e2 by blast
  show ?thesis using e3 by simp
qed

end
