theory question_36_10

imports Main

begin

typedecl entity
typedecl event

consts
  TransplantedOrganCells :: "entity ⇒ bool"
  TransplantedKidneyCells :: "entity ⇒ bool"
  CancerCells :: "entity ⇒ bool"
  AntigensFoundOn :: "entity ⇒ bool"

(* Explanation 1: Antigens are found on transplanted organ cells, which include transplanted kidney cells. *)
axiomatization where
  explanation_1: "∀x. TransplantedOrganCells x ⟶ TransplantedKidneyCells x"

(* Explanation 2: Antigens are also found on cancer cells. *)
axiomatization where
  explanation_2: "∀x. CancerCells x ⟶ AntigensFoundOn x"

theorem hypothesis:
  assumes asm: "CancerCells x ∨ TransplantedKidneyCells x"
  (* Hypothesis: Antigens are found on cancer cells and the cells of transplanted kidneys. *)
  shows "AntigensFoundOn x"
proof -
  assume asm: "CancerCells x ∨ TransplantedKidneyCells x"
  {
    assume "CancerCells x"
    then have "AntigensFoundOn x" by (rule explanation_2)
  }
  moreover {
    assume "TransplantedKidneyCells x"
    then have "TransplantedOrganCells x" by (rule explanation_1)
    then have "AntigensFoundOn x" by (rule explanation_1, rule explanation_2)
  }
  ultimately show "AntigensFoundOn x" by blast
qed

end
