theory question_17_9
imports Main

begin

typedecl entity
typedecl event
typedecl trophic_level

consts
  Omnivores :: "entity ⇒ bool"
  Feed :: "event ⇒ bool"
  Plants :: "entity ⇒ bool"
  TrophicLevel :: "trophic_level ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Producer :: "entity ⇒ bool"
  FirstTrophicLevel :: "trophic_level ⇒ bool"
  Consumers :: "entity ⇒ bool"
  HigherThanFirstTrophicLevel :: "trophic_level ⇒ bool"
  NotEqual :: "trophic_level ⇒ trophic_level ⇒ bool"

(* Explanation 1: Omnivores feed on plants, which are producers at the first trophic level. *)
axiomatization where
  explanation_1: "∀x e p t. Omnivores x ∧ Feed e ∧ Plants p ∧ TrophicLevel t ∧ Agent e x ∧ Patient e p ∧ Producer p ∧ FirstTrophicLevel t"

(* Explanation 2: Omnivores also feed on consumers that are at various trophic levels higher than the first. *)
axiomatization where
  explanation_2: "∀x e c t. Omnivores x ∧ Feed e ∧ Consumers c ∧ TrophicLevel t ∧ Agent e x ∧ Patient e c ∧ HigherThanFirstTrophicLevel t"

(* Explanation 3: Omnivores feed at multiple trophic levels, specifically the first and at least one other level that is higher than the first. *)
axiomatization where
  explanation_3: "∀x e t1 t2. Omnivores x ∧ Feed e ∧ TrophicLevel t1 ∧ TrophicLevel t2 ∧ Agent e x ∧ Patient e p1 ∧ Patient e p2 ∧ FirstTrophicLevel t1 ∧ HigherThanFirstTrophicLevel t2 ∧ ∃p1 p2. Patient e p1 ∧ Patient e p2"

theorem hypothesis:
  assumes asm: "Omnivores x ∧ Feed e1 ∧ Feed e2 ∧ TrophicLevel t1 ∧ TrophicLevel t2 ∧ Agent e1 x ∧ Agent e2 x ∧ Patient e1 p1 ∧ Patient e2 p2 ∧ NotEqual t1 t2 ∧ Patient e1 p1 ∧ Patient e2 p2"
  (* Hypothesis: Omnivores can feed at more than one trophic level. *)
  shows "∃x e1 e2 t1 t2. Omnivores x ∧ Feed e1 ∧ Feed e2 ∧ TrophicLevel t1 ∧ TrophicLevel t2 ∧ Agent e1 x ∧ Agent e2 x ∧ Patient e1 p1 ∧ Patient e2 p2 ∧ NotEqual t1 t2 ∧ Patient e1 p1 ∧ Patient e2 p2"
proof -
  {
    assume "Omnivores x" and "Feed e1" and "Feed e2" and "TrophicLevel t1" and "TrophicLevel t2"
           and "Agent e1 x" and "Agent e2 x" and "Patient e1 p1" and "Patient e2 p2" and "NotEqual t1 t2"
    from this have "Omnivores x ∧ Feed e1 ∧ Agent e1 x ∧ Patient e1 p1" by simp
    from this have "Plants p1 ∧ Producer p1 ∧ FirstTrophicLevel t1" using explanation_1 by blast
    from this have "Omnivores x ∧ Feed e2 ∧ Agent e2 x ∧ Patient e2 p2" by simp
    from this have "Consumers p2 ∧ HigherThanFirstTrophicLevel t2" using explanation_2 by blast
    from this have "∃p1 p2. Patient e1 p1 ∧ Patient e2 p2" by blast
  }
  then show ?thesis using asm by blast
qed

end
