theory question_46_2

imports Main

begin
typedecl entity
typedecl event
consts
  Boy :: "entity ⇒ bool"
  Fruit :: "entity ⇒ bool"
  StreetCart :: "entity ⇒ bool"
  OrangeShirt :: "entity ⇒ bool"
  Sells :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  From :: "entity ⇒ entity ⇒ bool"
  StreetVendor :: "entity ⇒ bool"

(* Explanation 1: A boy who sells fruit from a street cart is a street vendor. *)
axiomatization where
  explanation_1: "∀x y z e. Boy x ∧ Fruit y ∧ StreetCart z ∧ Sells e ∧ Agent e x ∧ Patient e y ∧ From y z ⟶ StreetVendor x"

theorem hypothesis:
  (* Premise: A boy in an orange shirt sells fruit from a street cart. *)
  assumes asm: "Boy x ∧ OrangeShirt x ∧ Fruit y ∧ StreetCart z ∧ Sells e ∧ Agent e x ∧ Patient e y ∧ From y z"
  (* Hypothesis: A boy is a street vendor. *)
  shows "∃x. Boy x ∧ StreetVendor x"
proof -
  from asm have "Boy x ∧ Fruit y ∧ StreetCart z ∧ Sells e ∧ Agent e x ∧ Patient e y ∧ From y z" by blast
  then have "StreetVendor x" using explanation_1 by blast
  show ?thesis using `Boy x` `StreetVendor x` by blast
qed

end
