theory question_80_4

imports Main

begin

typedecl entity
typedecl event

consts
  Insulator :: "entity ⇒ bool"
  ConductsElectricity :: "entity ⇒ bool"

(* Explanation 1: Insulator means a material that does not allow electricity to flow through it. *)
axiomatization where
  explanation_1: "∀x. Insulator x ↔ ¬ConductsElectricity x"

theorem hypothesis:
  (* Premise: Some materials are electrical conductors. *)
  assumes asm: "Materials x ∧ ElectricalConductors x"
  (* Hypothesis: Copper is the material that conducts electricity. *)
  shows "∃x. Copper x  ∧ ConductsElectricity x "
proof -
  from asm have "Materials x" by simp
  then obtain e1 where e1: "ElectricalConductors x ∧ Insulator x" using explanation_1 by blast
  then have "¬ConductsElectricity x" using e1 by simp
  then show ?thesis using asm `¬ConductsElectricity x` by blast
qed

end
