theory question_23_0

imports Main

begin

typedecl entity
typedecl event

consts
  Hurricane :: "entity ⇒ bool"
  Tornado :: "entity ⇒ bool"
  HighWinds :: "event ⇒ bool"
  Has :: "event ⇒ entity ⇒ bool"

(* Explanation 1: a hurricane has high wind speeds. *)
axiomatization where
  explanation_1: "∀x e. Hurricane x ∧ HighWinds e ∧ Has e x"

(* Explanation 2: a tornado has high wind speeds. *)
axiomatization where
  explanation_2: "∀x e. Tornado x ∧ HighWinds e ∧ Has e x"  

theorem hypothesis:
  assumes asm: "Hurricane x ∧ Tornado y ∧ HighWinds e"
  (* Hypothesis: Both hurricanes and tornadoes always have high winds. *)
  shows "∃x y z e. Hurricane x ∧ Tornado y ∧ HighWinds e ∧ Have e x y z"
proof -
  from asm have "Hurricane x ∧ Tornado y ∧ HighWinds e" by simp
  then obtain z where z: "Have e x y z" using explanation_1 by blast
  then have "HighWinds e ∧ Have e x y z" using z by simp
  show ?thesis using asm conclusion `HighWinds e ∧ Have e x y z` by blast
qed

end
