theory question_71_3

imports Main

begin

typedecl entity
typedecl event

consts
  Boy :: "entity ⇒ bool"
  ShallowEnough :: "event ⇒ bool"
  Walking :: "event ⇒ bool"
  On :: "event ⇒ entity ⇒ bool"
  Shallow :: "entity ⇒ bool"

(* Explanation 1: A boy can walk on water if it is shallow enough for him to walk. *)
axiomatization where
  explanation_1: "∀x e. Boy x ∧ ShallowEnough e ∧ Walking e ∧ On e Water"

(* Explanation 2: A boy can walk on water if the water is shallow. *)
axiomatization where
  explanation_2: "∀x e. Boy x ∧ Shallow e ∧ Walking e ∧ On e Water"

(* Explanation 3: If the water is shallow, a boy can walk on it. *)
axiomatization where
  explanation_3: "∀e. Shallow e ⟶ Walking e ∧ On e Water"

theorem hypothesis:
  (* Premise: A boy walks through the water. *)
  assumes asm: "Boy x ∧ Walking e ∧ Through e Water"
  (* Hypothesis: A boy walks on water. *)
  shows "∃x e. Boy x ∧ Walking e ∧ On e Water"
proof -
  from asm have "Boy x ∧ Walking e ∧ Through e Water" by blast
  from this have "ShallowEnough e" using explanation_1 by blast
  show ?thesis using `ShallowEnough e` `Boy x` `Walking e` `On e Water` by blast
qed

end
