theory question_51_0

imports Main

begin

typedecl entity
typedecl event
consts
  Man :: "entity ⇒ bool"
  SpeechGiving :: "event ⇒ bool"
  PublicSpeaking :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  OrnateCostumeParty :: "entity ⇒ bool"

(* Explanation 1: If someone gives a speech that means that they are speaking. *)
axiomatization where
  explanation_1: "∀x e. SpeechGiving e ⟶ PublicSpeaking e ∧ Agent e x"

theorem hypothesis:
  (* Premise: A man gives a speech at an ornate costume party. *)
  assumes asm: "Man x ∧ SpeechGiving e ∧ OrnateCostumeParty y ∧ Agent e x ∧ In e y"
  (* Hypothesis: A man is public speaking. *)
  shows "∃x e. Man x ∧ PublicSpeaking e ∧ Agent e x"
proof -
  from asm have "Man x" by blast
  from asm have "SpeechGiving e" by blast
  from explanation_1 have "PublicSpeaking e ∧ Agent e x" using `SpeechGiving e` by blast
  show ?thesis using `Man x` `PublicSpeaking e` `Agent e x` by blast
qed

end
