theory question_60_0

imports Main

begin

typedecl entity
typedecl event

consts
  PhaseChanges :: "entity ⇒ bool"
  Mass :: "entity ⇒ bool"
  Change :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Solid :: "entity ⇒ bool"
  Liquid :: "entity ⇒ bool"
  HeatEnergy :: "entity ⇒ bool"
  Melting :: "entity ⇒ bool"
  Add :: "event ⇒ entity ⇒ bool"
  PhaseChange :: "entity ⇒ bool"
  Weight :: "entity ⇒ bool"
  Property :: "entity ⇒ entity ⇒ bool"
  Matter :: "entity ⇒ bool"
  Objects :: "entity ⇒ bool"
  Materials :: "entity ⇒ bool"
  Ice :: "entity ⇒ bool"
  Melted :: "event ⇒ bool"
  Beaker :: "entity ⇒ bool"
  Windowsill :: "entity ⇒ bool"
  Containing :: "event ⇒ bool"
  Placed :: "event ⇒ bool"
  Melts :: "event ⇒ bool"

(* Explanation 1: phase changes do not change mass. *)
axiomatization where
  explanation_1: "∀x y e. PhaseChanges x ∧ Mass y ⟶ ¬(Change e ∧ Agent e y)"

(* Explanation 2: melting means changing from a solid into a liquid by adding heat energy. *)
axiomatization where
  explanation_2: "∀x y z e. Solid x ∧ Liquid y ∧ HeatEnergy z ∧ Melting x ⟶ Change e ∧ Agent e x ∧ Patient e y ∧ Add e z"

(* Explanation 3: melting is a kind of phase change. *)
axiomatization where
  explanation_3: "∀x. Melting x ⟶ PhaseChange x"

(* Explanation 4: mass; weight is a property of matter; objects; materials. *)
axiomatization where
  explanation_4: "∀x y. (Mass x ∨ Weight x) ⟶ Property x y ∧ (Matter y ∨ Objects y ∨ Materials y)"

theorem hypothesis:
  (* Premise: a beaker containing 50 milliliters of ice is placed on a windowsill. *)
  assumes asm1: "∃x y z e1 e2. Beaker x ∧ Ice y ∧ Windowsill z ∧ Containing e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Placed e2 ∧ Agent e2 x ∧ Patient e2 z"
  (* Premise: after several hours, the ice melts. *)
  assumes asm2: "∃x e. Ice x ∧ Melts e ∧ Agent e x"
  (* Hypothesis: The mass of the ice did not change when it melted. *)
  shows "∃x y e1 e2. Ice x ∧ Mass y ∧ Melted e1 ∧ Agent e1 x ∧ ¬Change e2 ∧ Agent e2 y"
proof -
  from asm2 obtain x e where ice_melt: "Ice x ∧ Melts e ∧ Agent e x" by auto
  then have "Melting x" using explanation_2 by blast
  then have "PhaseChange x" using explanation_3 by blast
  then have "¬(Change e ∧ Agent e x)" using explanation_1 by blast
  then have "Mass y" using explanation_4 by blast
  show ?thesis using asm2 `Mass y` `¬(Change e ∧ Agent e x)` by blast
qed

end
