theory question_81_10

imports Main

begin

typedecl entity
typedecl event

consts
  BottleneckEffect :: "entity ⇒ bool"
  Population :: "entity ⇒ bool"
  MuchSmaller :: "entity ⇒ bool"
  Occurs :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Gets :: "event ⇒ bool"
  ExternalMigration :: "entity ⇒ bool"
  Triggers :: "event ⇒ bool"

(* Explanation 1: Bottleneck effect is an event that occurs when a population suddenly gets much smaller. *)
axiomatization where
  explanation_1: "∀x y z e1 e2. BottleneckEffect x ∧ Population y ∧ MuchSmaller z ∧ Occurs e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Gets e2 ∧ Agent e2 y ∧ Patient e2 z"

(* Explanation 2: When external migration occurs, it directly triggers the bottleneck effect, which is an event. *)
axiomatization where
  explanation_2: "∀x y e1 e2. ExternalMigration x ∧ BottleneckEffect y ∧ Occurs e1 ∧ Agent e1 x ∧ Triggers e2 ∧ Agent e2 x ∧ Patient e2 y"  

theorem hypothesis:
  assumes asm: "BottleneckEffect x ∧ ExternalMigration y"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
  shows "∃x y e. BottleneckEffect x ∧ ExternalMigration y ∧ Occurs e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "BottleneckEffect x" by simp
  then obtain e1 where e1: "Occurs e1 ∧ Agent e1 x" using explanation_1 by blast
  from asm have "ExternalMigration y" by simp
  then obtain e2 where e2: "Occurs e2 ∧ Agent e2 y" using explanation_2 by blast
  have conclusion: "Occurs e1 ∧ Agent e1 x ∧ Patient e1 y" using e1 e2 by simp
  show ?thesis using asm conclusion by blast
qed

end
