theory question_81_1

imports Main

begin

typedecl entity
typedecl event

consts
  BottleneckEffect :: "entity ⇒ bool"
  Population :: "entity ⇒ bool"
  Suddenly :: "entity ⇒ bool"
  Smaller :: "entity ⇒ bool"
  Occurs :: "event ⇒ bool"
  Gets :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  ExternalMigration :: "entity ⇒ bool"
  Cause :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Occur :: "event ⇒ bool"

(* Explanation 1: Bottleneck effect occurs when a population suddenly gets much smaller. *)
axiomatization where
  explanation_1: "∀x y e1 e2. BottleneckEffect x ∧ Population y ∧ Suddenly y ∧ Smaller y ∧ Occurs e1 ∧ Agent e1 x ∧ Gets e2 ∧ Agent e2 y"

(* Explanation 2: External migration can cause a population to suddenly get much smaller. *)
axiomatization where
  explanation_2: "∀x y e1 e2. ExternalMigration x ∧ Population y ∧ Suddenly y ∧ Smaller y ∧ Cause e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Gets e2 ∧ Agent e2 y"

(* Explanation 3: Therefore, the bottleneck effect can occur due to external migration. *)
axiomatization where
  explanation_3: "∃x y e. BottleneckEffect x ∧ ExternalMigration y ∧ Occur e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  assumes asm: "BottleneckEffect x ∧ ExternalMigration y"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
  shows "∃x y e. BottleneckEffect x ∧ ExternalMigration y ∧ Occur e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "BottleneckEffect x ∧ ExternalMigration y" by simp
  then obtain e1 where e1: "Occurs e1 ∧ Agent e1 x" using explanation_1 by blast
  then obtain e2 where e2: "Gets e2 ∧ Agent e2 y" using explanation_2 by blast
  then have "Occur e ∧ Agent e x ∧ Patient e y" using explanation_3 by blast
  show ?thesis using asm e1 e2 `Occur e ∧ Agent e x ∧ Patient e y` by blast
qed

end
