theory question_88_4
imports Main
begin
typedecl entity
typedecl event

consts
  Gymnast :: "entity ⇒ bool"
  Skills :: "entity ⇒ bool"
  Flip :: "event ⇒ bool"
  Does :: "event ⇒ entity ⇒ event ⇒ bool"
  Displays :: "event ⇒ entity ⇒ entity ⇒ bool"
  Abilities :: "entity ⇒ bool"
  Show :: "event ⇒ entity ⇒ entity ⇒ bool"
  Flooring :: "entity ⇒ bool"
  Blue :: "entity ⇒ bool"
  On :: "event ⇒ entity ⇒ bool"

(* Explanation 1: When a gymnast does a flip, they are displaying their skills. *)
axiomatization where
  explanation_1: "∀x y e1 e2. Gymnast x ∧ Skills y ∧ Flip e1 ∧ Does e1 x e2 ⟶ Displays e2 x y"

(* Explanation 2: Displaying skills is a way for a gymnast to show their abilities. *)
axiomatization where
  explanation_2: "∀x y z e1 e2. Gymnast x ∧ Skills y ∧ Abilities z ∧ Displays e1 x y ⟶ Show e2 x z"

theorem hypothesis:
  (* Premise: Gymnast does a flip on blue flooring. *)
  assumes asm: "Gymnast x ∧ Flip y ∧ Flooring z ∧ Blue z ∧ Does e x y ∧ On e z"
  (* Hypothesis: A gymnast displays their skills with a flip *)
  shows "∃x y e. Gymnast x ∧ Skills y ∧ Flip e ∧ Displays e x y"
proof -
  from asm have "Gymnast x ∧ Flip y ∧ Does e x y" by blast
  then have "∃y. Skills y ∧ Displays e x y" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
