theory question_81_1
imports Main
begin

typedecl entity
typedecl event

consts
  Soil :: "entity ⇒ bool"
  Forest :: "entity ⇒ bool"
  NonlivingPartOf :: "entity ⇒ entity ⇒ bool"
  Environment :: "entity ⇒ bool"
  NonlivingComponent :: "entity ⇒ entity ⇒ bool"
  PartOf :: "entity ⇒ entity ⇒ bool"
  NonlivingThing :: "entity ⇒ bool"

(* Explanation 1: Soil is usually a nonliving component of an environment. *)
axiomatization where
  explanation_1: "∀x y. Soil x ∧ Environment y ⟶ NonlivingComponent x y"

(* Explanation 2: A forest is a kind of environment. *)
axiomatization where
  explanation_2: "∀x. Forest x ⟶ Environment x"

(* Explanation 3: Soil is a kind of nonliving thing. *)
axiomatization where
  explanation_3: "∀x. Soil x ⟶ NonlivingThing x"

(* Explanation 4: Soil is usually part of an environment. *)
axiomatization where
  explanation_4: "∀x y. Soil x ∧ Environment y ⟶ PartOf x y"

theorem hypothesis:
  assumes asm: "Soil x ∧ Forest y"
  (* Hypothesis: Soil is a nonliving part of a forest. *)
  shows "NonlivingPartOf x y"
proof -
  from asm have "Soil x" and "Forest y" by simp+
  then have "NonlivingComponent x y" using explanation_1 by blast
  then have "PartOf x y" using explanation_4 by blast
  then show ?thesis using `Soil x` `Forest y` by blast
qed

end
