theory question_17_0

imports Main

begin

typedecl entity
typedecl event

consts
  Consumers :: "entity ⇒ bool"
  TrophicLevel :: "entity ⇒ bool"
  MoreThanOne :: "entity ⇒ entity ⇒ bool"
  Feed :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Plants :: "entity ⇒ bool"
  Producers :: "entity ⇒ bool"
  Omnivores :: "entity ⇒ bool"

(* Explanation 1: Many consumers feed at more than one trophic level. *)
axiomatization where
  explanation_1: "∀x e. Consumers x ∧ (∃y z. TrophicLevel y ∧ TrophicLevel z ∧ MoreThanOne y z ∧ Feed e ∧ Agent e x ∧ Patient e y ∧ Patient e z)"

(* Explanation 2: Plants are producers are consumers are omnivores. *)
axiomatization where
  explanation_2: "∀x. Plants x ⟶ Producers x ∧ Consumers x ∧ Omnivores x"

theorem hypothesis:
  assumes asm: "Omnivores x"
  (* Hypothesis: Omnivores can feed at more than one trophic level. *)
  shows "∃x e. Omnivores x ∧  TrophicLevel y ∧ TrophicLevel z ∧ MoreThanOne y z ∧ Feed e ∧ Agent e x ∧ Patient e y ∧ Patient e z "
proof -
  from asm have "Omnivores x" by simp
  then obtain e y z where e: "TrophicLevel y ∧ TrophicLevel z ∧ MoreThanOne y z ∧ Feed e ∧ Agent e x ∧ Patient e y ∧ Patient e z" using explanation_1 by blast
  have "Plants x" using explanation_2 by blast
  then have "Producers x ∧ Consumers x" using explanation_2 by blast
  then have "Omnivores x" using explanation_2 by blast
  have conclusion: "TrophicLevel y ∧ TrophicLevel z ∧ MoreThanOne y z ∧ Feed e ∧ Agent e x ∧ Patient e y ∧ Patient e z" using e by simp
  show ?thesis using asm conclusion by blast
qed

end
