theory question_98_0
imports Main

begin
typedecl entity
typedecl event

consts
  Man :: "entity ⇒ bool"
  Pool :: "entity ⇒ bool"
  Jumping :: "event ⇒ bool"
  OutOf :: "event ⇒ entity ⇒ bool"
  Goggles :: "entity ⇒ bool"
  Splashing :: "event ⇒ bool"
  Wearing :: "entity ⇒ entity ⇒ bool"
  Everywhere :: "event ⇒ entity ⇒ bool"

(* Explanation 1: There is both a man jumping out of a pool. *)
axiomatization where
  explanation_1: "∃x e. Man x ∧ Pool e ∧ Jumping e ∧ OutOf e x"

theorem hypothesis:
  (* Premise: A young man wearing goggles, is jumping out of a pool, splashing water everywhere. *)
  assumes asm: "Man x ∧ Goggles y ∧ Pool z ∧ Jumping e ∧ Splashing e ∧ Wearing x y ∧ OutOf e x ∧ Everywhere e z"
  (* Hypothesis: Man jumping out of a pool. *)
  shows "∃x e. Man x ∧ Pool e ∧ Jumping e ∧ OutOf e x"
proof -
  from asm have "Man x ∧ Pool z ∧ Jumping e ∧ OutOf e x" by blast
  then show ?thesis using explanation_1 by blast
qed

end
