theory question_77_0

imports Main

begin
typedecl entity
typedecl event

consts
  Gold :: "entity ⇒ bool"
  Light :: "entity ⇒ bool"
  GoldenColoredDog :: "entity ⇒ bool"
  LightColoredDog :: "entity ⇒ bool"
  Dog :: "entity ⇒ bool"
  LightColored :: "entity ⇒ bool"
  AlertEyes :: "entity ⇒ bool"
  TennisBall :: "entity ⇒ bool"
  BrightlyColored :: "entity ⇒ bool"
  Holds :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  InMouth :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: The colour gold is a light one, thus a golden-colored dog is a light-colored dog. *)
axiomatization where
  explanation_1: "∀x. Gold x ∧ Light x ⟶ (∀y. GoldenColoredDog y ⟶ LightColoredDog y)"

theorem hypothesis:
  (* Premise: A golden-colored dog, with his eyes alert, holds a brightly colored tennis ball in his mouth. *)
  assumes asm: "GoldenColoredDog x ∧ AlertEyes x ∧ TennisBall y ∧ BrightlyColored z ∧ Holds e ∧ Agent e x ∧ Patient e y ∧ InMouth x y"
  (* Hypothesis: The dog is light colored. *)
  shows "∃x. Dog x ∧ LightColored x"
proof -
  from asm have "GoldenColoredDog x" by blast
  then have "LightColoredDog x" using explanation_1 by blast
  then show ?thesis using `Dog x` by blast
qed

end
