theory question_50_0

imports Main

begin
typedecl entity
typedecl event

consts
  Man :: "entity ⇒ bool"
  DirtBike :: "entity ⇒ bool"
  Riding :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Racetrack :: "entity ⇒ bool"
  On :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Both sentences state that a man is riding a dirt bike. *)
axiomatization where
  explanation_1: "∃x y e. Man x ∧ DirtBike y ∧ Riding e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  (* Premise: A man riding a dirt bike on a racetrack. *)
  assumes asm: "Man x ∧ DirtBike y ∧ Racetrack z ∧ Riding e ∧ Agent e x ∧ Patient e y ∧ On e z"
  (* Hypothesis: A man is riding a dirt bike. *)
  shows "∃x y e. Man x ∧ DirtBike y ∧ Riding e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Man x ∧ DirtBike y ∧ Riding e ∧ Agent e x ∧ Patient e y" by blast
  then show ?thesis using explanation_1 by blast
qed

end
