theory question_49_1

imports Main

begin
typedecl entity
typedecl event

consts
  Group :: "entity ⇒ bool"
  People :: "entity ⇒ bool"
  Costumes :: "event ⇒ bool"
  Wearing :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  PartOf :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A group consists of people. *)
axiomatization where
  explanation_1: "∀x. Group x ⟶ People x"

(* Explanation 2: People are part of a group. *)
axiomatization where
  explanation_2: "∀x. People x ⟶ Group x"

theorem hypothesis:
  (* Premise: A group of people are wearing costumes *)
  assumes asm: "Group x ∧ People y ∧ Costumes e ∧ Wearing e ∧ PartOf y x"
  (* Hypothesis: People are wearing costumes. *)
  shows "∃x e. People x ∧ Costumes e ∧ Wearing e ∧ Agent e x"
proof -
  from asm have "Group x" and "People y" and "Costumes e" and "Wearing e" and "PartOf y x" by blast
  then have "People y" using explanation_1 by blast
  then show ?thesis using `People y` `Costumes e` `Wearing e` by blast
qed

end
