# Do’s and Don’ts

* **Search tickets before you file a new one.** Add to tickets if you have new information about the issue.
* **Keep tickets short but sweet.** Make sure you include all the context needed to solve the issue. Don't overdo it. Great tickets allow us to focus on solving problems instead of discussing them.
* **Take care of your ticket.** When you spend time to report a ticket with care we'll enjoy fixing it for you.
* **Use [GitHub-flavored Markdown](https://help.github.com/articles/markdown-basics/).** Especially put code blocks and console outputs in backticks (```` ``` ````). That increases the readability. Bonus points for applying the appropriate syntax highlighting. (Tip: Podfiles are written in a Ruby DSL.)
* **Do not litter.** Don’t add +1’s _unless_ specifically asked for and don’t discuss offtopic issues.
* **Spell the name of the project correctly.** It's CocoaPods. In upper camel case.

## Bug Reports

In short, since you are most likely a developer, provide a ticket that you _yourself_ would _like_ to receive.

We are **not** here to support your individual projects. We depend on _you_ (the community)
to contribute in making the tool better for everyone. So debug and reduce your own issues
before creating a ticket and let us know of all the things you tried and their outcome.
This applies double if you cannot share a reproduction with us because of internal company
policies.

## Feature Requests

Please try to be precise about the proposed outcome of the feature and how it
would related to existing features.


## Pull Requests

All contributions _will_ be licensed under the MIT license.

Code/comments should adhere to the following rules:

* Names should be descriptive and concise.
* All enhancements and bug fixes need to be documented in the CHANGELOG.
* When writing comments, use properly constructed sentences, including
  punctuation.
* When documenting APIs and/or source code, don't make assumptions or make
  implications about race, gender, religion, political orientation or anything
  else that isn't relevant to the project.
* Remember that source code usually gets written once and read often: ensure
  the reader doesn't have to make guesses. Make sure that the purpose and inner
  logic are either obvious to a reasonably skilled professional, or add a
  comment that explains it.

## [No Brown M&M’s](https://en.wikipedia.org/wiki/Van_Halen#Contract_riders)

If you made it all the way to the end, bravo dear user, we love you. You can include
this emoji in the top of your ticket to signal to us that you did in fact read this
file and are trying to conform to it as best as possible: 🌈
