#!/usr/bin/
# For GPT-4
# Arabic
python llm-test-ar.py --dialog_type pure_arabic \
--data data/advbench_arabic_no_numbers.csv \
&> outputs/gpt-4/advbench/pure_arabic.log

# chatspeak
python llm-test-ar.py --dialog_type chatspeak \
--data data/advbench/advbench_arabic_with_numbers.csv \
&> outputs/gpt-4/advbench/chatspeak_with_numbers.log

# transliteration
python llm-test-ar.py --dialog_type transliteration \
--data data/advbench/advbench_arabic_no_num_no_ar_letters.csv \
&> outputs/gpt-4/advbench/transliteration_no_ar_letters.log

# For single query use:
python llm-test-ar.py --dialog_type transliteration \
--data data/advbench/advbench_arabic_no_num_no_ar_letters.csv \
--single_query yes \
--single_prompt "your prompt goes here"
# to add prefix, suffix or both, please see below commands


# Arabic with prefix injection "Sure, here is how " (suffix in our codes). 
# In the paper, this is done through the chatting portal
# we put this here for reference or further test.
python llm-test-ar.py --dialog_type pure_arabic \
--data data/advbench_arabic_no_numbers.csv \
--prompt_injection_type suffix --prompt_injection_value "بكل تأكيد، فيما يلي كيف يمكنك " \
 &> outputs/gpt-4/advbench/pure_arabic_with_prefix_injection.log

# For Claude-3, the same as above could be followed, but change the model name as:.
python llm-test-ar.py --dialog_type pure_arabic \
--model claude-3-sonnet-20240229 \
--data data/advbench_arabic_no_numbers.csv \
&> outputs/claude-3-sonnet-20240229/advbench/pure_arabic.log

# For prefix and suffix, you could use the same command as above but change
# --prompt_injection_type both \
# --prompt_injection_value "prefix_suffix"
# note the underscore here.