# 8월 버전입니다. 추후 사용할 때 수정할 예정입니다.
def DegreesOfFreedom(count_block: Block, num_row: int, alpha: float, stat_type: str) -> Block:
    eval = count_block.context.homevaluator
    keypack = count_block.context.public_key
    int((num_row - 1) / count_block.num_slots) + 1
    res_block = Block.zeros(count_block.context, encrypted=False)
    compare_block = Block.zeros(count_block.context, encrypted=False)
    stat_block = Block.zeros(count_block.context, encrypted=False)
    if stat_type == "t":
        stat_func = scipy.t
    elif stat_type == "chisquare":
        stat_func = scipy.chi2
    else:
        raise Exception("[Error] No such distribution type")

    skip_index = int((num_row - 10000) / (count_block.num_slots - 10000)) + 1
    for i in range(count_block.num_slots):
        if num_row <= count_block.num_slots:
            compare_block[i] = i + 1
            stat_block[i] = stat_func(i + 1).ppf(alpha)
        else:
            if i < 10000:
                compare_block[i] = i + 1
                stat_block[i] = stat_func(i + 1).ppf(alpha)
            else:
                compare_block[i] = 10000 + (i - 9999) * skip_index
                stat_block[i] = stat_func(10000 + (i - 9999) * skip_index).ppf(alpha)
    compare_block.encrypt
    tmp_block = count_block - compare_block
    if num_row < count_block.num_slots:
        tmp_block *= 54 / count_block.num_slots
    else:
        tmp_block *= 16 / (count_block.num_slots * skip_index)

    count_block.context.heaan.math.approx.discrete_equal_zero(eval, keypack, tmp_block.data, tmp_block.data)
    res_block = __rotate_sum(tmp_block)
    res_block = res_block.inverse(one_slot=True)
    tmp_block *= stat_block
    tmp_block = __rotate_sum(tmp_block)
    res_block *= tmp_block
    return res_block
