#!/usr/bin/env bash

# summDIR="/home/tiger/summ/MSPM"
# unsupervisedDIR=$2

DIR=$1
lmDIR=$2
DATAVER=$3
split=$4

get_seeded_random()
{
  seed="$1"
  openssl enc -aes-256-ctr -pass pass:"$seed" -nosalt \
    </dev/zero 2>/dev/null
}

OUTDIR=$DIR/$DATAVER
mkdir $OUTDIR

echo "Concat unsupervised data with summarization data ..."
cat $DIR/en/${split}.en.spm.doc $DIR/fr/${split}.fr.spm.doc $lmDIR/es.doc.spm.noise $lmDIR/de.doc.spm.noise $lmDIR/zh.doc.spm.noise > $OUTDIR/${split}.noshuffle.spm.doc
cat $DIR/en/${split}.en.spm.sum $DIR/fr/${split}.fr.spm.sum $lmDIR/es.doc.spm.sample $lmDIR/de.doc.spm.sample $lmDIR/zh.doc.spm.sample > $OUTDIR/${split}.noshuffle.spm.sum

echo "shuffling"
shuf --random-source=<(get_seeded_random 66) $OUTDIR/${split}.noshuffle.spm.doc > $OUTDIR/${split}.spm.doc
shuf --random-source=<(get_seeded_random 66) $OUTDIR/${split}.noshuffle.spm.sum > $OUTDIR/${split}.spm.sum

