import torch
from abc import abstractmethod
from nlp_safety_prop.models.representations import Representer
from typing import List


class Embedder(Representer):
    @abstractmethod
    def get_embeddings(self, data: List[dict]) -> torch.Tensor:
        pass

    @abstractmethod
    def get_representations(self, text: str) -> torch.Tensor:
        pass
