FAIRSEQ_ROOT="your_code_dir"
LS_ROOT="data_dir"
SAVE_DIR="checkpoints_save_dir"
CUDA_VISIBLE_DEVICES=0,1,2,3
python    ${FAIRSEQ_ROOT}/train.py ${LS_ROOT} --save-dir ${SAVE_DIR} \
    --arch transformer_canmt --share-all-embeddings \
    --optimizer adam --adam-betas '(0.9, 0.98)' --clip-norm 0.0 \
    --lr 5e-4 --lr-scheduler inverse_sqrt --warmup-updates 4000 --warmup-init-lr 1e-07 \
    --dropout 0.3 --weight-decay 0.0001 \
    --criterion label_smoothed_cross_entropy --label-smoothing 0.1 \
    --max-tokens 4096 --update-freq 2  --save-interval-updates 1000 \
    --eval-bleu  \
    --eval-bleu-args '{"beam": 5, "max_len_a": 1.2, "max_len_b": 10}' \
    --eval-bleu-detok moses \
    --eval-bleu-remove-bpe '@@ ' --weight 1.0 \
    --eval-bleu-print-samples --fp16 \
    --best-checkpoint-metric bleu --maximize-best-checkpoint-metric  --scoring sacrebleu
