"""Collect the checking functions for each single operator.

Notes: compound aggregation types are not supported, FOR NOW.
"""

from preprocess.operation.argument import check_argument
from preprocess.operation.group_and_binary import check_group, check_binary
from preprocess.operation.compare import check_greater, check_less
from preprocess.operation.deprecated import check_rank, check_compare
from preprocess.operation.null import check_null
from preprocess.operation.compound import check_compound


CHECK_FUNCS = {
    # arguments
    'argmax': check_argument, 'argmin': check_argument, 
    'pairargmax': check_argument, 'pairargmin': check_argument, 
    # 'topkargmax': check_argument, 'topkargmin': check_argument, 
    # 'kthargmax': check_argument, 'kthargin': check_argument, 
    # grouping
    'sum': check_group, 'average': check_group, 
    'max': check_group, 'min':check_group, 
    'count': check_group, 
    # binary 
    'diff': check_binary, 'div': check_binary, 
    # null
    'none': check_null, 'opp': check_null, 
    # comparison
    # 'greater': check_compound,   # check_greater, 
    # 'less': check_compound,    # check_less, 
    # deprecated
    'rank': check_compound,    # check_rank, 
    'compare': check_compound,     # check_compare, 
    # compound, currently for manual check
    'compound': check_compound,
}
