# pylint: disable=no-self-use,invalid-name

from allennlp.common.testing import ModelTestCase


class TestBiMPM(ModelTestCase):
    def setUp(self):
        super(TestBiMPM, self).setUp()
        self.set_up_model(self.FIXTURES_ROOT / 'bimpm' / 'experiment.json',
                          self.FIXTURES_ROOT / 'data' / 'quora_paraphrase.tsv')

    def test_forward_pass_runs_correctly(self):
        training_tensors = self.dataset.as_tensor_dict()
        output_dict = self.model(**training_tensors)
        assert "logits" in output_dict and "loss" in output_dict

    def test_model_can_train_save_and_load(self):
        self.ensure_model_can_train_save_and_load(self.param_file)

    def test_batch_predictions_are_consistent(self):
        self.ensure_batch_predictions_are_consistent()

    def test_decode_runs_correctly(self):
        training_tensors = self.dataset.as_tensor_dict()
        output_dict = self.model(**training_tensors)
        decode_output_dict = self.model.decode(output_dict)
        assert "label" in decode_output_dict
