/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.meteor.aligner;

import edu.cmu.meteor.aligner.Match;
import java.util.Arrays;

public class PartialAlignment {
    public Match[] matches;
    public int matchCount;
    public int matches1;
    public int matches2;
    public int allMatches1;
    public int allMatches2;
    public int chunks;
    public int idx;
    public int lastMatchEnd;
    public int distance;
    public boolean[] line1UsedWords;
    public boolean[] line2UsedWords;

    public PartialAlignment(Match[] matchArray, boolean[] blArray, boolean[] blArray2) {
        this.matches = Arrays.copyOf(matchArray, matchArray.length);
        this.matchCount = 0;
        this.matches1 = 0;
        this.matches2 = 0;
        this.allMatches1 = 0;
        this.allMatches2 = 0;
        this.chunks = 0;
        this.idx = 0;
        this.lastMatchEnd = -1;
        this.distance = 0;
        this.line1UsedWords = Arrays.copyOf(blArray, blArray.length);
        this.line2UsedWords = Arrays.copyOf(blArray2, blArray2.length);
    }

    public PartialAlignment(PartialAlignment partialAlignment) {
        this.matches = Arrays.copyOf(partialAlignment.matches, partialAlignment.matches.length);
        this.matchCount = partialAlignment.matchCount;
        this.matches1 = partialAlignment.matches1;
        this.matches2 = partialAlignment.matches2;
        this.allMatches1 = partialAlignment.allMatches1;
        this.allMatches2 = partialAlignment.allMatches2;
        this.chunks = partialAlignment.chunks;
        this.idx = partialAlignment.idx;
        this.lastMatchEnd = partialAlignment.lastMatchEnd;
        this.distance = partialAlignment.distance;
        this.line1UsedWords = Arrays.copyOf(partialAlignment.line1UsedWords, partialAlignment.line1UsedWords.length);
        this.line2UsedWords = Arrays.copyOf(partialAlignment.line2UsedWords, partialAlignment.line2UsedWords.length);
    }

    public boolean isUsed(Match match) {
        int n;
        for (n = 0; n < match.length; ++n) {
            if (!this.line2UsedWords[match.start + n]) continue;
            return true;
        }
        for (n = 0; n < match.matchLength; ++n) {
            if (!this.line1UsedWords[match.matchStart + n]) continue;
            return true;
        }
        return false;
    }

    public void setUsed(Match match, boolean bl) {
        int n;
        for (n = 0; n < match.length; ++n) {
            this.line2UsedWords[match.start + n] = bl;
        }
        for (n = 0; n < match.matchLength; ++n) {
            this.line1UsedWords[match.matchStart + n] = bl;
        }
    }
}

