from utils.config import *
from models.LTHR import *

'''
Command:

python test.py -ds=reasoning -bsz=8 -hdd=128 -lr=0.001 -evalp=10 -max_neg_cnt=5 -max_depth=3 -path=

'''

directory = args['path'].split("/")
HDD = directory[2].split('HDD')[1].split('BSZ')[0]
BSZ = int(directory[2].split('BSZ')[1].split('lr')[0])
if args['dataset'] == 'reasoning':
    DS = 'reasoning'
elif args['dataset'] == 'multiwoz':
    DS = 'multiwoz'

if DS == 'reasoning':
    from utils.utils_Ent_reasoning_for_synthetic import *
elif DS == 'multiwoz':
    from utils.utils_Ent_reasoning_for_multiwoz import *
else:
    print("You need to provide the --dataset information")

train, dev, test, lang, max_resp_len = prepare_data_seq(batch_size=BSZ)

model = LTHR(
	lang,
    int(HDD),
    int(HDD),
    int(args['max_depth']),
    float(args['learn']),
	args['path'],
    float(args['drop']),
    relations_cnt=lang.n_relations,
    entities_cnt=lang.n_entities)

acc_test = model.evaluate(test, 1e7)
