import argparse

def parse():
    parser = argparse.ArgumentParser()

#    parser.add_argument('-dev', 
#                        type=str,
#                        help='device',
#                        default='cuda:0')

    parser.add_argument('-cuda',
                        type=int,
                        nargs='+',
                        help='cuda list')

    parser.add_argument('-con', 
                        action="store_true",
                        help='is contrastive learning or not')

    parser.add_argument('-zero_shot', 
                        action="store_true",
                        help='zero shot test')

    parser.add_argument('-load', 
                        type=str,
                        help='load model from ./model/')

    parser.add_argument('-save', 
                        type=str,
                        help='save model to ./model/',
                        default='save')

    parser.add_argument('-log', 
                        type=str,
                        help='print log info to')

    parser.add_argument('-dataset', 
                        type=str,
                        default='open_entity',
                        help='dataset to use, default=open_entity')

    parser.add_argument('-data', 
                        type=str,
                        default='train',
                        help='data to use, default=train')

    parser.add_argument('-epoch', 
                        type=int,
                        default=15,
                        help='epochs to train, default=15')

    parser.add_argument('-batch_size', 
                        type=int,
                        default=16,
                        help='batch_size, default=16')

    parser.add_argument('-showall', 
                        action="store_true",
                        help='print the loss on test set after each epoch')

    parser.add_argument('-zh', 
                        action="store_true",
                        help='use chinese test set')

    return parser.parse_args()
