"""
This script extracts the messages for a given room from the message storage json.
Please use it like this: python extract_messages.py [INFILE] [ROOM_ID] [OUTFILE]
"""

import sys
import json
from pathlib import Path
from tinydb import TinyDB, where

if len(sys.argv) != 3:
    print("""Error: Please use this script like this:\n
             python extract_messages.py [INFILE] [OUTFOLDER]
          """)
    sys.exit(1)

INFILE, OUTFOLDER = sys.argv[1:]
OUTFOLDER = Path(OUTFOLDER)

db = TinyDB(INFILE)

room_ids = []
for entry in db:
    if entry["roomid"] not in room_ids:
        room_ids.append(entry["roomid"])

for room_id in room_ids:
    results = db.search(where("roomid") == room_id)
    for r in results:
        del r["roomid"]
    with open(OUTFOLDER.joinpath(f"{room_id.split(':')[0]}.json"), "w") as room_file:
        room_file.write(json.dumps(results))
