# ==================================   INDEP   ================================== #
from ..data_config import SIZE

######### Grain grain_num > 1 #########
Indep_Template_Prl_Grain = [
    # (+) =======================================
    [ 
        # STRUCTURE:
            'Tensor_Extractor',    
        # Meanings:
            {
                'InputMeaning':    'GrainVec_SeqAS_Token_SeqAS_Sent',
                'OutputMeaning':   'GrainVec_SeqAS_Token_SeqAS_Sent',
                'Reshape_Restore': 'GrainVec_SeqAs_Sent',
            },
        # NNName_NNPara
            [
                # NN Name
                'TFM',
                # NN Para
                {'type': 'tfm',
                 'input_type': 'INPUT-NML', 'direction_type': 'MIX',  'struct_type': 'EXTRACTOR', 
                 'input_size': SIZE, 'output_size': SIZE,
                 'nhead': 5, "num_encoder_layers": 2, "num_decoder_layers": 0, "dim_feedforward": 256, 
                 "tfm_dropout":  0.5, "tfm_activation": 'gelu',
                 'postprecess' :{
                     # 'dropout' :[True, {'p':0.5, 'inplace':False}],
                     # 'activiator': [True, 'relu'],
                     # 'layernorm': [True, {'eps': 1e-05, "elementwise_affine":True}],
                    }
                }
            ]
    ],
    
    # (+) Don't change this for CNN and TFM Tensor Extractor =======================================
    [ 
        # STRUCTURE:
            'Tensor_Reducer',    
        # Meanings:
            {
                'InputMeaning':    'GrainVec_SeqAS_Token_SeqAS_Sent',
                'OutputMeaning':   'TokenVec_SeqAS_Sent',
                'Reshape_Restore': 'GrainVec_SeqAs_Token', # this is always As_Token. Pay attention here.
            },
        # NNName_NNPara
            [
                # NN Name
                'Max',
                # NN Para
                {'type': 'Max', 
                 'input_size':  SIZE, 
                 'output_size': SIZE,
                 'postprecess' :{
                     # 'dropout' :[True, {'p':0.5, 'inplace':False}],
                     # 'activiator': [True, 'relu'],
                     # 'layernorm': [True, {'eps': 1e-05, "elementwise_affine":True}],
                    }
                }
            ]
    ],
    
    # (+) =======================================
    [ 
        # STRUCTURE:
            'Matrix_Extractor',    
        # Meanings:
            {
                'InputMeaning':  'TokenVec_SeqAS_Sent',
                'OutputMeaning': 'TokenVec_SeqAS_Sent',
                'Reshape_Restore': None,
            },
        # NNName_NNPara
            [
                # NN Name
                'TFM',
                # NN Para
                {'type': 'tfm',
                 'input_type': 'INPUT-NML', 'direction_type': 'MIX',  'struct_type': 'EXTRACTOR', 
                 'input_size': SIZE, 'output_size': SIZE,
                 'nhead': 5, "num_encoder_layers": 1, "num_decoder_layers": 0, "dim_feedforward": 256, 
                 "tfm_dropout":  0.5, "tfm_activation": 'gelu',
                 'postprecess' :{
                     # 'dropout' :[True, {'p':0.5, 'inplace':False}],
                     # 'activiator': [True, 'relu'],
                     # 'layernorm': [True, {'eps': 1e-05, "elementwise_affine":True}],
                    }
                }
            ]
    ]
]


# ==================================   INTERDEP  ================================== #

Interdep_Template = [
    # (+) DON'T CHANGE THIS PART =======================================
    [ 
        # STRUCTURE:
            'Tensor_Reducer',    
        # Meanings:
            {
                'InputMeaning':    'FieldVec_SeqAS_Token_SeqAS_Sent',
                'OutputMeaning':   'TokenVec_SeqAS_Sent',
                'Reshape_Restore':  None,
            },
        # NNName_NNPara
            [
                # NN Name
                'Sum',
                # NN Para
                {'type': 'sum', 
                 'input_size':  SIZE, 
                 'output_size': SIZE,
                 'postprecess' :{
                     'dropout' :[True, {'p':0.5, 'inplace':False}],
                     'layernorm': [True, {'eps': 1e-05, "elementwise_affine":True}],
                    }

                }
            ]
    ],
    
    # (+) =======================================
    [ 
        # STRUCTURE:
            'Matrix_Extractor',    
        # Meanings:
            {
                'InputMeaning':  'TokenVec_SeqAS_Sent',
                'OutputMeaning': 'TokenVec_SeqAS_Sent',
                'Reshape_Restore': None,
            },
        # NNName_NNPara
            [
                # NN Name
                'TFM',
                # NN Para
                {'type': 'tfm',
                 'input_type': 'INPUT-NML', 
                 'direction_type': 'MIX',  # 'FWD'
                 'struct_type': 'EXTRACTOR', 
                 'input_size': SIZE, 'output_size': SIZE,
                 'nhead': 5, "num_encoder_layers": 3, "num_decoder_layers": 0, "dim_feedforward": 256, 
                 "tfm_dropout":  0.5, "tfm_activation": 'gelu',
                 'postprecess' :{
                     # 'dropout' :[True, {'p':0.5, 'inplace':False}],
                     # 'activiator': [True, 'relu'],
                     # 'layernorm': [True, {'eps': 1e-05, "elementwise_affine":True}],
                    }
                }
            ]
    ]
]

