/*
 * Decompiled with CFR 0.152.
 */
package utils_bk;

import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeMap;
import utils_bk.DescStringIntMapComparator;

public class Stat {
    private int elemscol;
    private int attribscol;
    private String[] coldesc_arr;
    private Integer coldesc_arr_count;
    private HashMap<String, HashMap> elements;
    private Integer totalDataAdded;
    private Integer totalGlobalDataAdded;

    public Stat() {
        this(null, null, null);
    }

    public Stat(String[] coldesc) {
        this(coldesc, null, null);
    }

    public Stat(String[] coldesc, String elemscol_re) {
        this(coldesc, elemscol_re, null);
    }

    public Stat(String[] coldesc, String elemscol_re, String attribscol_re) {
        block7: {
            this.coldesc_arr = null;
            this.coldesc_arr_count = 0;
            this.totalDataAdded = 0;
            this.totalGlobalDataAdded = 0;
            this.elemscol = -1;
            this.attribscol = -1;
            try {
                if (coldesc == null || coldesc.length < 1) {
                    throw new Exception("Column description is null or empty");
                }
                this.coldesc_arr = new String[coldesc.length + 1];
                for (int i = 0; i < coldesc.length; ++i) {
                    this.coldesc_arr[i] = coldesc[i];
                }
                this.coldesc_arr[coldesc.length] = "span";
                this.coldesc_arr_count = coldesc.length + 1;
                if (elemscol_re != null) {
                    this.elemscol = this.getColumn(elemscol_re);
                }
                if (attribscol_re != null) {
                    this.attribscol = this.getColumn(attribscol_re);
                }
                if (this.elemscol == -1) {
                    this.elemscol = coldesc.length - 1;
                }
                this.elements = new HashMap();
            }
            catch (Exception e) {
                System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
                if (System.getProperty("DEBUG") == null || !System.getProperty("DEBUG").equalsIgnoreCase("true")) break block7;
                e.printStackTrace(System.err);
                System.exit(1);
            }
        }
    }

    public int getColsCount() {
        return this.coldesc_arr_count;
    }

    public int getElemsCol() {
        return this.elemscol;
    }

    public int getAttribsCol() {
        return this.attribscol;
    }

    public int getColumn(String colname_re) {
        for (int i = 0; i < this.coldesc_arr_count; ++i) {
            if (!this.coldesc_arr[i].matches(colname_re)) continue;
            return i;
        }
        return -1;
    }

    public String getColumnStr(int colpos) {
        try {
            if (colpos >= 0 && this.coldesc_arr.length > colpos) {
                return this.coldesc_arr[colpos];
            }
            throw new Exception("Column position < 0 or > total columns");
        }
        catch (Exception e) {
            System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
                System.exit(1);
            }
            return null;
        }
    }

    public void addData(String[] data) {
        block16: {
            Integer n = this.totalDataAdded;
            Integer n2 = this.totalDataAdded = Integer.valueOf(this.totalDataAdded + 1);
            try {
                Integer n3;
                HashMap<String, HashMap> dataMap = new HashMap<String, HashMap>();
                if (data.length != this.coldesc_arr_count) {
                    throw new Exception("Malformed data");
                }
                String datakey = this.attribscol != -1 ? (data[this.attribscol].matches(".*=\".*") || data[this.attribscol].matches(".*\\s+.*") || data[this.attribscol].equals("*") ? (data[this.elemscol].equalsIgnoreCase("EVENT") && data[this.attribscol].matches(".*class=\".*") ? data[this.elemscol] + "-" + data[this.attribscol].substring(data[this.attribscol].indexOf("class=\"") + 7, data[this.attribscol].indexOf(34, data[this.attribscol].indexOf("class=\"") + 7)) : (data[this.elemscol].equalsIgnoreCase("TIMEX3") && data[this.attribscol].matches(".*type=\".*") ? data[this.elemscol] + "-" + data[this.attribscol].substring(data[this.attribscol].indexOf("type=\"") + 6, data[this.attribscol].indexOf(34, data[this.attribscol].indexOf("type=\"") + 6)) : data[this.elemscol])) : data[this.elemscol] + "-" + data[this.attribscol]) : data[this.elemscol];
                if (this.elements.containsKey(datakey)) {
                    HashMap colsMap = this.elements.get(datakey);
                    for (int col = 0; col < this.coldesc_arr_count; ++col) {
                        if (col == this.elemscol || col == this.attribscol) continue;
                        HashMap colMap = (HashMap)colsMap.get(this.coldesc_arr[col]);
                        Integer colMapValue = (Integer)colMap.get(data[col]);
                        if (colMapValue != null) {
                            Integer n4 = colMapValue;
                            n3 = colMapValue = Integer.valueOf(colMapValue + 1);
                        } else {
                            colMapValue = 1;
                        }
                        colMap.put(data[col], colMapValue);
                    }
                    final Integer totalValue = (Integer)((HashMap)colsMap.get("total")).get("total") + 1;
                    colsMap.put("total", new HashMap<String, Integer>(){
                        {
                            this.put("total", totalValue);
                        }
                    });
                } else {
                    for (int col = 0; col < this.coldesc_arr_count; ++col) {
                        if (col == this.elemscol || col == this.attribscol) continue;
                        final String tempdata = data[col];
                        dataMap.put(this.coldesc_arr[col], new HashMap<String, Integer>(){
                            {
                                this.put(tempdata, 1);
                            }
                        });
                    }
                    dataMap.put("total", new HashMap<String, Integer>(){
                        {
                            this.put("total", 1);
                        }
                    });
                    this.elements.put(datakey, dataMap);
                }
                if (!datakey.equals(data[this.elemscol])) {
                    HashMap<String, HashMap> dataMapG = new HashMap<String, HashMap>();
                    if (this.elements.containsKey("0_GENERAL_" + data[this.elemscol])) {
                        HashMap colsMapG = this.elements.get("0_GENERAL_" + data[this.elemscol]);
                        for (int col = 0; col < this.coldesc_arr_count; ++col) {
                            if (col == this.elemscol || col == this.attribscol) continue;
                            HashMap colMapG = (HashMap)colsMapG.get(this.coldesc_arr[col]);
                            Integer colMapValue = (Integer)colMapG.get(data[col]);
                            if (colMapValue != null) {
                                n3 = colMapValue;
                                Integer n5 = colMapValue = Integer.valueOf(colMapValue + 1);
                            } else {
                                colMapValue = 1;
                            }
                            colMapG.put(data[col], colMapValue);
                        }
                        final Integer totalValue = (Integer)((HashMap)colsMapG.get("total")).get("total") + 1;
                        colsMapG.put("total", new HashMap<String, Integer>(){
                            {
                                this.put("total", totalValue);
                            }
                        });
                    } else {
                        for (int col = 0; col < this.coldesc_arr_count; ++col) {
                            if (col == this.elemscol || col == this.attribscol) continue;
                            final String tempdata = data[col];
                            dataMapG.put(this.coldesc_arr[col], new HashMap<String, Integer>(){
                                {
                                    this.put(tempdata, 1);
                                }
                            });
                        }
                        dataMapG.put("total", new HashMap<String, Integer>(){
                            {
                                this.put("total", 1);
                            }
                        });
                        this.elements.put("0_GENERAL_" + data[this.elemscol], dataMapG);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
                if (System.getProperty("DEBUG") == null || !System.getProperty("DEBUG").equalsIgnoreCase("true")) break block16;
                e.printStackTrace(System.err);
                System.exit(1);
            }
        }
    }

    public void addGLOBALdata(String statkey, String statsubkey) {
        block8: {
            try {
                HashMap colsMapGlobal;
                Integer colMapValue = 1;
                Integer n = this.totalGlobalDataAdded;
                Integer n2 = this.totalGlobalDataAdded = Integer.valueOf(this.totalGlobalDataAdded + 1);
                if (!this.elements.containsKey("GLOBAL")) {
                    this.createGLOBALelement();
                }
                if ((colsMapGlobal = this.elements.get("GLOBAL")).containsKey(statkey)) {
                    HashMap colMapGlobal = (HashMap)colsMapGlobal.get(statkey);
                    if (colMapGlobal.containsKey(statsubkey)) {
                        colMapValue = (Integer)colMapGlobal.get(statsubkey);
                        if (colMapValue != null) {
                            Integer n3 = colMapValue;
                            Integer n4 = colMapValue = Integer.valueOf(colMapValue + 1);
                        } else {
                            colMapValue = 1;
                        }
                        colMapGlobal.put(statsubkey, colMapValue);
                    } else {
                        colMapGlobal.put(statsubkey, 1);
                    }
                }
                final Integer totalValue = (Integer)((HashMap)colsMapGlobal.get("total")).get("total") + 1;
                colsMapGlobal.put("total", new HashMap<String, Integer>(){
                    {
                        this.put("total", totalValue);
                    }
                });
            }
            catch (Exception e) {
                System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
                if (System.getProperty("DEBUG") == null || !System.getProperty("DEBUG").equalsIgnoreCase("true")) break block8;
                e.printStackTrace(System.err);
                System.exit(1);
            }
        }
    }

    public void print() {
        this.print(1, 0);
    }

    public void print(int minpercent, int minpercentCorpus) {
        System.out.println("\nPrinting Statistics (total Data " + this.totalDataAdded + ")\n-------------------------");
        if (this.elements.get("GLOBAL") != null) {
            this.printGlobal(minpercent, minpercentCorpus);
        } else {
            this.printSimple(minpercent);
        }
    }

    public void printSimple(int minpercent) {
        for (String current_key : this.elements.keySet()) {
            HashMap colsMap = this.elements.get(current_key);
            Integer elementTotal = (Integer)((HashMap)colsMap.get("total")).get("total");
            System.out.println(current_key + "(" + elementTotal + ")");
            for (String cols_key : colsMap.keySet()) {
                if (cols_key.equalsIgnoreCase("total")) continue;
                System.out.println("\t" + cols_key);
                HashMap colMap = (HashMap)colsMap.get(cols_key);
                TreeMap sortedColMap = new TreeMap(new DescStringIntMapComparator(colMap));
                sortedColMap.putAll(colMap);
                for (String col_key : sortedColMap.keySet()) {
                    Integer colValue = (Integer)colMap.get(col_key);
                    int colPercent = (int)Math.round((double)colValue.intValue() / (double)elementTotal.intValue() * 100.0);
                    if (colPercent < minpercent) continue;
                    System.out.println("\t\t" + col_key + "\t" + colPercent + "%" + " (" + colValue + ")");
                }
                System.out.println();
            }
            System.out.println();
        }
        System.out.println();
    }

    public void printGlobal(int minpercent, int minpercentCorpus) {
        HashMap colsMapGlobal = this.elements.get("GLOBAL");
        Object[] keylist = this.elements.keySet().toArray(new String[0]);
        Arrays.sort(keylist);
        for (Object current_key : keylist) {
            if (((String)current_key).equals("GLOBAL")) continue;
            HashMap colsMap = this.elements.get(current_key);
            Integer elementTotal = (Integer)((HashMap)colsMap.get("total")).get("total");
            System.out.println((String)current_key + "(" + elementTotal + ")");
            for (String cols_key : colsMap.keySet()) {
                if (cols_key.equals("total") || cols_key.equals("attribs")) continue;
                System.out.println("\t" + cols_key);
                HashMap colMap = (HashMap)colsMap.get(cols_key);
                HashMap colMapGlobal = (HashMap)colsMapGlobal.get(cols_key);
                TreeMap sortedColMap = new TreeMap(new DescStringIntMapComparator(colMap));
                sortedColMap.putAll(colMap);
                for (String col_key : sortedColMap.keySet()) {
                    int colPercent;
                    Integer colValue = (Integer)colMap.get(col_key);
                    Integer globalValue = (Integer)colMapGlobal.get(col_key);
                    if (globalValue == null) {
                        globalValue = colValue * 1000;
                    }
                    if ((colPercent = (int)Math.round((double)colValue.intValue() / (double)elementTotal.intValue() * 100.0)) < minpercent) continue;
                    double globPercent = (double)((int)Math.round((double)colValue.intValue() / (double)globalValue.intValue() * 1000.0)) / 10.0;
                    System.out.print("\t\t" + col_key + "\t" + colPercent + "%" + " (" + colValue + ")");
                    if (globPercent >= (double)minpercentCorpus && globPercent > 0.1 && !cols_key.equals("span")) {
                        System.out.print("  ----> " + globPercent + "% of corpus (" + globalValue + ")");
                    }
                    System.out.println();
                }
                System.out.println();
            }
            System.out.println();
        }
        System.out.println();
    }

    public void createGLOBALelement() {
        HashMap colsMapGlobal = new HashMap();
        for (int currcol = 0; currcol < this.coldesc_arr_count; ++currcol) {
            if (currcol == this.elemscol || currcol == this.attribscol) continue;
            colsMapGlobal.put(this.coldesc_arr[currcol], new HashMap());
        }
        colsMapGlobal.put("total", new HashMap<String, Integer>(){
            {
                this.put("total", 1);
            }
        });
        this.elements.put("GLOBAL", colsMapGlobal);
    }
}

