/*
 * Decompiled with CFR 0.152.
 */
package nlp_files;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import nlp_files.NLPFile;
import utils_bk.FileUtils;
import utils_bk.Stat;
import utils_bk.StringUtils;

public class PipesFile
extends NLPFile {
    private String[] pipes_desc_arr = null;
    private Integer pipes_desc_arr_count = 0;
    public Boolean isWellFormed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isWellFormedOptimist() {
        try {
            File pipes_desc_file;
            if (!super.isLoaded().booleanValue()) {
                throw new Exception("No file loaded in NLPFile object");
            }
            if (this.extension.matches("\\s*")) {
                throw new Exception("PipesFile must have an extension (i.e., .tok)");
            }
            if (this.extension.contains("annotatedWith")) {
                this.extension = this.extension.substring(0, this.extension.lastIndexOf("-annotatedWith") + 14);
            }
            if (this.extension.contains("annotationKey")) {
                this.extension = this.extension.substring(0, this.extension.lastIndexOf("-annotationKey") + 14);
            }
            if (!((pipes_desc_file = new File(this.f.getCanonicalPath().substring(0, this.f.getCanonicalPath().lastIndexOf(47) + 1) + this.extension + ".pipes-desc")).exists() && pipes_desc_file.isFile() || (pipes_desc_file = new File(FileUtils.getApplicationPath() + FileUtils.NLPFiles_descr_path + this.extension + ".pipes-desc")).exists() && pipes_desc_file.isFile())) {
                throw new Exception("PipesFile description file (" + this.extension + ".pipes-desc) not found in " + pipes_desc_file.getCanonicalPath());
            }
            BufferedReader reader = new BufferedReader(new FileReader(pipes_desc_file));
            try {
                String line = null;
                int linen = 0;
                while ((line = reader.readLine()) != null) {
                    ++linen;
                    if (line.equals("word")) {
                        this.pipes_desc_arr = new String[1];
                        this.pipes_desc_arr[0] = "word";
                        this.pipes_desc_arr_count = 1;
                    } else {
                        if (!line.matches(".*\\|.*")) continue;
                        this.pipes_desc_arr = line.split("\\|");
                        this.pipes_desc_arr_count = this.pipes_desc_arr.length;
                    }
                    break;
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            if (this.pipes_desc_arr == null) {
                throw new Exception(pipes_desc_file + " is not a valid PipesFile description file");
            }
        }
        catch (Exception e) {
            System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
                System.exit(1);
            }
            return false;
        }
        this.isWellFormed = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isWellFormed() {
        try {
            String line;
            File pipes_desc_file;
            if (!super.isLoaded().booleanValue()) {
                throw new Exception("No file loaded in NLPFile object");
            }
            if (this.extension.matches("\\s*")) {
                throw new Exception("PipesFile must have an extension (i.e., .tok)");
            }
            if (this.extension.contains("annotatedWith")) {
                this.extension = this.extension.substring(0, this.extension.lastIndexOf("-annotatedWith") + 14);
            }
            if (this.extension.contains("annotationKey")) {
                this.extension = this.extension.substring(0, this.extension.lastIndexOf("-annotationKey") + 14);
            }
            if (!((pipes_desc_file = new File(this.f.getCanonicalPath().substring(0, this.f.getCanonicalPath().lastIndexOf(47) + 1) + this.extension + ".pipes-desc")).exists() && pipes_desc_file.isFile() || (pipes_desc_file = new File(FileUtils.getApplicationPath() + FileUtils.NLPFiles_descr_path + this.extension + ".pipes-desc")).exists() && pipes_desc_file.isFile())) {
                throw new Exception("PipesFile description file (" + this.extension + ".pipes-desc) not found in " + pipes_desc_file.getCanonicalPath());
            }
            BufferedReader reader = new BufferedReader(new FileReader(pipes_desc_file));
            try {
                line = null;
                int linen = 0;
                while ((line = reader.readLine()) != null) {
                    ++linen;
                    if (!line.matches(".*\\|.*")) continue;
                    this.pipes_desc_arr = line.split("\\|");
                    this.pipes_desc_arr_count = this.pipes_desc_arr.length;
                    break;
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            if (this.pipes_desc_arr == null) {
                throw new Exception(pipes_desc_file + " is not a valid PipesFile description file");
            }
            reader = new BufferedReader(new FileReader(this.f));
            try {
                line = null;
                String lastline = null;
                int linen = 0;
                while ((line = reader.readLine()) != null) {
                    ++linen;
                    lastline = line;
                    if (line.length() > 0 && line.matches("[^\\|]+")) {
                        throw new Exception("Line " + linen + " is not valid pipesFile line: Has contet without |");
                    }
                    if (line.length() <= 1 || !line.matches(".*\\|.*") || line.split("\\|").length >= this.pipes_desc_arr_count) continue;
                    throw new Exception("Line " + linen + " is not valid pipesFile line: Has less columns (" + line.split("\\|").length + ") than description file(" + this.pipes_desc_arr_count + ")");
                }
                if (!this.extension.matches("(tab|pipes.*|TempEval.*|roth-.*|srlpaired.*|poslemma.*)") && !lastline.trim().equals("|")) {
                    throw new Exception("Last line does not end with an end sentence marker |. (DEPRECATED... MODIFY..)");
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (Exception e) {
            System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
                System.exit(1);
            }
            return false;
        }
        this.isWellFormed = true;
        return true;
    }

    public String[] getPipesDescArr() {
        return this.pipes_desc_arr;
    }

    public int getPipesDescArrCount() {
        return this.pipes_desc_arr_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sentSplit() {
        String outputfile = this.getFile().toString() + ".pipes";
        int numline = 0;
        try {
            BufferedReader pipesreader = new BufferedReader(new FileReader(this.f));
            BufferedWriter outfile = new BufferedWriter(new FileWriter(outputfile));
            int sentcolumn = 1;
            int filecolumn = 0;
            try {
                String line;
                String numsent = "-1";
                String filename = "-1";
                while ((line = pipesreader.readLine()) != null) {
                    ++numline;
                    String[] linearr = line.split("\\|");
                    if (!(filename.equals(linearr[filecolumn]) && numsent.equals(linearr[sentcolumn]) || numsent.equals("-1") || filename.equals("-1"))) {
                        outfile.write("|\n");
                    }
                    for (int i = 3; i < linearr.length - 1; ++i) {
                        outfile.write(linearr[i] + "|");
                    }
                    outfile.write(linearr[linearr.length - 1] + "\n");
                    numsent = linearr[sentcolumn];
                    filename = linearr[filecolumn];
                }
                outfile.write("|\n");
            }
            finally {
                if (pipesreader != null) {
                    pipesreader.close();
                }
                if (outfile != null) {
                    outfile.close();
                }
            }
        }
        catch (Exception e) {
            System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + " (line " + numline + ")\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
                System.exit(1);
            }
            return null;
        }
        return outputfile;
    }

    public String detectLanguage() {
        return "en";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toPlain() {
        String outputfile = this.getFile().toString() + ".plain";
        try {
            BufferedWriter outfile = new BufferedWriter(new FileWriter(outputfile));
            if (!this.isWellFormed.booleanValue()) {
                throw new Exception("Malformed pipes file");
            }
            int tokcolumn = this.getColumn("(token|word).*");
            int blankscolumn = this.getColumn("(leading.?blanks?|blanks)");
            int sentnumcolumn = this.getColumn("sent-num");
            BufferedReader pipesreader = new BufferedReader(new FileReader(this.f));
            try {
                String line;
                String outputline = "";
                int current_sentence = 0;
                while ((line = pipesreader.readLine()) != null) {
                    String[] linearr = line.split("\\|");
                    if (linearr.length >= this.pipes_desc_arr_count) {
                        String token = linearr[tokcolumn];
                        if (this.extension.equalsIgnoreCase("TempEval-bs")) {
                            if (token.matches("(\\*.*|0)")) continue;
                            if (token.matches("-.+-")) {
                                if (token.equals("-LRB-")) {
                                    token = "(";
                                }
                                if (token.equals("-RRB-")) {
                                    token = ")";
                                }
                                if (token.equals("-LSB-")) {
                                    token = "[";
                                }
                                if (token.equals("-RSB-")) {
                                    token = "]";
                                }
                                if (token.equals("-LCB-")) {
                                    token = "{";
                                }
                                if (token.equals("-RCB-")) {
                                    token = "}";
                                }
                            }
                            if (sentnumcolumn != -1 && Integer.parseInt(linearr[sentnumcolumn]) != current_sentence) {
                                current_sentence = Integer.parseInt(linearr[sentnumcolumn]);
                                outfile.write(outputline + "\n");
                                outputline = token;
                                continue;
                            }
                            if (!outputline.equals("")) {
                                outputline = outputline + " ";
                            }
                            outputline = outputline + token;
                            continue;
                        }
                        if (blankscolumn != -1) {
                            for (int i = 1; i <= Integer.parseInt(linearr[blankscolumn]); ++i) {
                                outputline = outputline + " ";
                            }
                        } else if (!outputline.equals("")) {
                            outputline = outputline + " ";
                        }
                        outputline = outputline + token;
                        continue;
                    }
                    ++current_sentence;
                    outfile.write(outputline + "\n");
                    outputline = "";
                }
                if (!outputline.equals("")) {
                    outfile.write(outputline + "\n");
                }
            }
            finally {
                if (pipesreader != null) {
                    pipesreader.close();
                }
                if (outfile != null) {
                    outfile.close();
                }
            }
        }
        catch (Exception e) {
            System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
                System.exit(1);
            }
            return null;
        }
        return outputfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pair_pipes_by_column_JOIN(int paircol, String model, int modelcol) {
        String outputfile = this.getFile().toString() + ".paired";
        try {
            if (!this.isWellFormed.booleanValue()) {
                throw new Exception("Malformed pipes file");
            }
            if (paircol < 0 || this.pipes_desc_arr_count < paircol) {
                throw new Exception("Paircol (" + paircol + ") does not exist");
            }
            PipesFile modelpipes = new PipesFile();
            modelpipes.loadFile(new File(model));
            modelpipes.isWellFormedOptimist();
            if (modelcol < 0 || modelpipes.getPipesDescArrCount() < modelcol) {
                throw new Exception("Modelcol (" + modelcol + ") does not exist (total: " + modelpipes.getPipesDescArrCount() + ") ");
            }
            BufferedWriter outfile = new BufferedWriter(new FileWriter(outputfile));
            BufferedReader modelreader = new BufferedReader(new FileReader(model));
            BufferedReader pipesreader = new BufferedReader(new FileReader(this.f));
            try {
                String line;
                String pairline = "";
                String[] pairarr = null;
                String pipespair = "";
                Boolean paired = true;
                while ((line = modelreader.readLine()) != null) {
                    String[] linearr = line.split("\\|");
                    if (linearr.length >= modelpipes.getPipesDescArrCount()) {
                        String modelpair = linearr[modelcol];
                        if (paired.booleanValue()) {
                            pairline = pipesreader.readLine();
                            while (pairline != null && (pairline.equals("|") || pairline.trim().equals(""))) {
                                pairline = pipesreader.readLine();
                            }
                            if (pairline != null) {
                                pairarr = pairline.split("\\|");
                                pipespair = pairarr[paircol];
                            }
                        }
                        paired = modelpair.equals(pipespair) ? Boolean.valueOf(true) : (modelpair.equals("\"") && (pipespair.equals("``") || pipespair.equals("''")) ? Boolean.valueOf(true) : (modelpair.matches("-.+-") ? (modelpair.equals("-LRB-") && pipespair.equals("(") || modelpair.equals("-RRB-") && pipespair.equals(")") ? Boolean.valueOf(true) : (modelpair.equals("-LSB-") && pipespair.equals("[") || modelpair.equals("-RSB-") && pipespair.equals("]") ? Boolean.valueOf(true) : (modelpair.equals("-LCB-") && pipespair.equals("{") || modelpair.equals("-RCB-") && pipespair.equals("}") ? Boolean.valueOf(true) : Boolean.valueOf(false)))) : Boolean.valueOf(false)));
                    }
                    outfile.write(line);
                    if (modelpipes.getPipesDescArrCount() > 1) {
                        for (int i = 0; i < this.pipes_desc_arr_count; ++i) {
                            if (i == paircol) continue;
                            if (paired.booleanValue() && pairarr != null) {
                                outfile.write("|" + pairarr[i]);
                                continue;
                            }
                            outfile.write("|-");
                        }
                    }
                    if (paired.booleanValue()) {
                        pairarr = null;
                        pairline = "";
                        pipespair = "";
                    }
                    outfile.write("\n");
                }
            }
            finally {
                if (pipesreader != null) {
                    pipesreader.close();
                }
                if (modelreader != null) {
                    modelreader.close();
                }
                if (outfile != null) {
                    outfile.close();
                }
            }
        }
        catch (Exception e) {
            System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
                System.exit(1);
            }
            return null;
        }
        return outputfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pair_ancora2pipes(int modelcol, String AnCoraPath, int paircol) {
        String outputfile = this.getFile().toString() + ".roth-treetag";
        try {
            if (!this.isWellFormed.booleanValue()) {
                throw new Exception("Malformed pipes file");
            }
            if (modelcol < 0 || this.pipes_desc_arr_count < modelcol) {
                throw new Exception("Pairtextcol (" + modelcol + ") does not exist (total: " + this.pipes_desc_arr_count + ") ");
            }
            BufferedWriter outfile = new BufferedWriter(new FileWriter(outputfile));
            BufferedReader modelreader = new BufferedReader(new FileReader(this.f));
            try {
                String line;
                int syntcolumn = -1;
                int lemmacolumn = -1;
                String accomulatedsynt = "";
                String pairline = "";
                String[] pairarr = null;
                String pipespair = "";
                Boolean inMultiword = false;
                Boolean paired = true;
                String currentpairfile = "";
                BufferedReader pipesreader = null;
                PipesFile pairpipes = null;
                while ((line = modelreader.readLine()) != null) {
                    String[] linearr = line.split("\\|");
                    String pairfile = AnCoraPath + linearr[0].substring(0, linearr[0].lastIndexOf(46) + 1) + "tbf.utf8.roth-treetag";
                    if (!new File(pairfile).exists() && pairfile.matches(".*_[a-z]\\.tbf\\.utf8\\.roth-treetag")) {
                        pairfile = pairfile.replaceFirst("_[a-z]\\.tbf", "\\.tbf");
                    }
                    if (!currentpairfile.equals(pairfile)) {
                        currentpairfile = pairfile;
                        if (pipesreader != null) {
                            pipesreader.close();
                        }
                        pairpipes = new PipesFile();
                        pairpipes.loadFile(new File(pairfile));
                        pairpipes.isWellFormedOptimist();
                        if (paircol < 0 || pairpipes.getPipesDescArrCount() < paircol) {
                            throw new Exception("Paircol (" + paircol + ") does not exist");
                        }
                        pipesreader = new BufferedReader(new FileReader(pairfile));
                        syntcolumn = pairpipes.getColumn("synt");
                        lemmacolumn = pairpipes.getColumn("lemma");
                        System.out.println(pairfile + "(synt " + syntcolumn + ")(lemma " + lemmacolumn + ")");
                    }
                    if (linearr.length >= this.pipes_desc_arr_count) {
                        String modelpair = linearr[modelcol];
                        if (paired.booleanValue()) {
                            pairline = pipesreader.readLine();
                            while (pairline != null && pairline.equals("|")) {
                                pairline = pipesreader.readLine();
                            }
                            if (pairline != null) {
                                pairarr = pairline.split("\\|");
                                pipespair = pairarr[paircol];
                            }
                        }
                        if (modelpair.equalsIgnoreCase(pipespair) || modelpair.equalsIgnoreCase("Bar\u00e7a") && pipespair.equalsIgnoreCase("Barca")) {
                            paired = true;
                            inMultiword = false;
                            System.out.println("pairing: " + pipespair);
                        } else {
                            System.out.println("not Equal " + pairline + " - " + line + "\n");
                            if (pipespair.equals("(")) {
                                System.out.println("NOT!! Find next braket ) -->");
                                int parlevel = 0;
                                parlevel += StringUtils.countOccurrencesOf((String)pairarr[syntcolumn], (char)'(');
                                parlevel -= StringUtils.countOccurrencesOf((String)pairarr[syntcolumn], (char)')');
                                while (pairline != null && !pipespair.equals(")")) {
                                    pairline = pipesreader.readLine();
                                    if (pairline != null) {
                                        pairarr = pairline.split("\\|");
                                        pipespair = pairarr[paircol];
                                    } else {
                                        System.out.println("End of file reached...");
                                        System.exit(1);
                                    }
                                    parlevel += StringUtils.countOccurrencesOf((String)pairarr[syntcolumn], (char)'(');
                                    parlevel -= StringUtils.countOccurrencesOf((String)pairarr[syntcolumn], (char)')');
                                }
                                if (parlevel < 0) {
                                    for (int p = 0; p > parlevel; --p) {
                                        accomulatedsynt = accomulatedsynt + ")";
                                    }
                                }
                                if ((pairline = pipesreader.readLine()) != null) {
                                    pairarr = pairline.split("\\|");
                                    pipespair = pairarr[paircol];
                                } else {
                                    System.out.println("End of file reached...while looking for )");
                                    System.exit(1);
                                }
                            }
                            if (pipespair.matches("[\",%-]") && !modelpair.matches("[\",%-]") && !pairarr[syntcolumn].matches(".*\\((inc|nominalSent)((\\s+|\\().*)?")) {
                                System.out.println("NOT!! Omit symbols ) -->");
                                while (pairline != null && !pipespair.equals(modelpair)) {
                                    accomulatedsynt = accomulatedsynt + pairarr[syntcolumn];
                                    Boolean sentend = false;
                                    if (pairline.equals("|")) {
                                        sentend = true;
                                    }
                                    if ((pairline = pipesreader.readLine()) != null) {
                                        if (!pairline.equals("|")) {
                                            pairarr = pairline.split("\\|");
                                            pipespair = pairarr[paircol];
                                        } else {
                                            pipespair = "|";
                                        }
                                    } else {
                                        System.out.println("End of file reached...");
                                        System.exit(1);
                                    }
                                    if (!sentend.booleanValue()) continue;
                                    accomulatedsynt = "";
                                    break;
                                }
                            }
                            if (modelpair.equals(pipespair)) {
                                paired = true;
                                inMultiword = false;
                            } else {
                                paired = false;
                                System.out.println("NOT!! modelpair:" + modelpair + " - pipespair:" + pipespair);
                                String trypair = pipespair;
                                if (pipespair.contains("_")) {
                                    trypair = pipespair.substring(0, pipespair.indexOf(95));
                                }
                                System.out.println("Try:" + trypair);
                                if (trypair.equals(modelpair)) {
                                    inMultiword = true;
                                    pipespair = pipespair.substring(pipespair.indexOf(95) + 1);
                                } else {
                                    int p;
                                    String accomulatednorm;
                                    String accomulatedinc;
                                    int nomparlevel;
                                    int incparlevel;
                                    int parlevel;
                                    while (!paired.booleanValue() && pairarr[syntcolumn].matches(".*\\((inc|nominalSent)((\\s+|\\().*)?")) {
                                        parlevel = 0;
                                        incparlevel = 1000;
                                        nomparlevel = 1000;
                                        accomulatedinc = "";
                                        accomulatednorm = "";
                                        if (pairarr[syntcolumn].matches(".*\\(inc((\\s+|\\().*)?")) {
                                            incparlevel = StringUtils.countOccurrencesOf((String)pairarr[syntcolumn].substring(0, pairarr[syntcolumn].indexOf("(inc")), (char)'(');
                                            accomulatedinc = pairarr[syntcolumn].substring(0, pairarr[syntcolumn].indexOf("(inc"));
                                        }
                                        if (pairarr[syntcolumn].matches(".*\\(nominalSent((\\s+|\\().*)?")) {
                                            nomparlevel = StringUtils.countOccurrencesOf((String)pairarr[syntcolumn].substring(0, pairarr[syntcolumn].indexOf("(nominalSent")), (char)'(');
                                            accomulatednorm = pairarr[syntcolumn].substring(0, pairarr[syntcolumn].indexOf("(nominalSent"));
                                        }
                                        if (nomparlevel < incparlevel) {
                                            incparlevel = nomparlevel;
                                            accomulatedsynt = accomulatedsynt + accomulatednorm;
                                        } else {
                                            accomulatedsynt = accomulatedinc;
                                        }
                                        parlevel += StringUtils.countOccurrencesOf((String)pairarr[syntcolumn], (char)'(');
                                        parlevel -= StringUtils.countOccurrencesOf((String)pairarr[syntcolumn], (char)')');
                                        System.out.println("REMOVE INC/nominalsent=" + incparlevel);
                                        while (pairline != null) {
                                            System.out.println("palevel=" + parlevel + "  -  " + pairline + " ---(" + modelpair);
                                            if (parlevel <= incparlevel) {
                                                if (parlevel < incparlevel) {
                                                    for (p = incparlevel; p > parlevel; --p) {
                                                        accomulatedsynt = accomulatedsynt + ")";
                                                    }
                                                }
                                                System.out.println("END INC");
                                                pairline = pipesreader.readLine();
                                                while (pairline != null && pairline.equals("|")) {
                                                    pairline = pipesreader.readLine();
                                                }
                                                if (pairline != null) {
                                                    pairarr = pairline.split("\\|");
                                                    pipespair = pairarr[paircol];
                                                    break;
                                                }
                                                System.out.println("INC End of file reached...");
                                                System.exit(1);
                                                break;
                                            }
                                            pairline = pipesreader.readLine();
                                            if (pairline != null && !pairline.equals("|")) {
                                                pairarr = pairline.split("\\|");
                                                pipespair = pairarr[paircol];
                                                parlevel += StringUtils.countOccurrencesOf((String)pairarr[syntcolumn], (char)'(');
                                                parlevel -= StringUtils.countOccurrencesOf((String)pairarr[syntcolumn], (char)')');
                                                continue;
                                            }
                                            System.out.println("INC End of file/sentence reached...");
                                            System.exit(1);
                                        }
                                        if (modelpair.equals(pipespair)) {
                                            paired = true;
                                            inMultiword = false;
                                            continue;
                                        }
                                        if (!pipespair.contains("_")) continue;
                                        trypair = pipespair.substring(0, pipespair.indexOf(95));
                                        System.out.println("Try:" + trypair);
                                        if (!trypair.equals(modelpair)) continue;
                                        inMultiword = true;
                                        pipespair = pipespair.substring(pipespair.indexOf(95) + 1);
                                    }
                                    if (!(paired.booleanValue() || inMultiword.booleanValue() || modelpair.equals("\""))) {
                                        System.out.println("NOT!! Find next sentence");
                                        accomulatedsynt = "";
                                        while (pairline != null && !pairline.equals("|")) {
                                            pairline = pipesreader.readLine();
                                        }
                                        while (pairline != null && pairline.equals("|")) {
                                            pairline = pipesreader.readLine();
                                        }
                                        if (pairline != null) {
                                            pairarr = pairline.split("\\|");
                                            pipespair = pairarr[paircol];
                                        } else {
                                            System.out.println("End of file reached...");
                                            System.exit(1);
                                        }
                                        if (modelpair.equals(pipespair)) {
                                            paired = true;
                                            inMultiword = false;
                                        } else if (pipespair.contains("_")) {
                                            trypair = pipespair.substring(0, pipespair.indexOf(95));
                                            System.out.println("Try:" + trypair);
                                            if (trypair.equals(modelpair)) {
                                                inMultiword = true;
                                                pipespair = pipespair.substring(pipespair.indexOf(95) + 1);
                                            }
                                        }
                                    }
                                    while (!paired.booleanValue() && pairarr[syntcolumn].matches(".*\\((inc|nominalSent)((\\s+|\\().*)?")) {
                                        parlevel = 0;
                                        incparlevel = 1000;
                                        nomparlevel = 1000;
                                        accomulatedinc = "";
                                        accomulatednorm = "";
                                        if (pairarr[syntcolumn].matches(".*\\(inc((\\s+|\\().*)?")) {
                                            incparlevel = StringUtils.countOccurrencesOf((String)pairarr[syntcolumn].substring(0, pairarr[syntcolumn].indexOf("(inc")), (char)'(');
                                            accomulatedinc = pairarr[syntcolumn].substring(0, pairarr[syntcolumn].indexOf("(inc"));
                                        }
                                        if (pairarr[syntcolumn].matches(".*\\(nominalSent((\\s+|\\().*)?")) {
                                            nomparlevel = StringUtils.countOccurrencesOf((String)pairarr[syntcolumn].substring(0, pairarr[syntcolumn].indexOf("(nominalSent")), (char)'(');
                                            accomulatednorm = pairarr[syntcolumn].substring(0, pairarr[syntcolumn].indexOf("(nominalSent"));
                                        }
                                        if (nomparlevel < incparlevel) {
                                            incparlevel = nomparlevel;
                                            accomulatedsynt = accomulatedsynt + accomulatednorm;
                                        } else {
                                            accomulatedsynt = accomulatedinc;
                                        }
                                        parlevel += StringUtils.countOccurrencesOf((String)pairarr[syntcolumn], (char)'(');
                                        parlevel -= StringUtils.countOccurrencesOf((String)pairarr[syntcolumn], (char)')');
                                        System.out.println("REMOVE INC/nominalsent=" + incparlevel);
                                        while (pairline != null) {
                                            System.out.println("palevel=" + parlevel + "  -  " + pairline + " ---(" + modelpair);
                                            if (parlevel <= incparlevel) {
                                                if (parlevel < incparlevel) {
                                                    for (p = incparlevel; p > parlevel; --p) {
                                                        accomulatedsynt = accomulatedsynt + ")";
                                                    }
                                                }
                                                pairline = pipesreader.readLine();
                                                while (pairline != null && pairline.equals("|")) {
                                                    pairline = pipesreader.readLine();
                                                }
                                                if (pairline != null) {
                                                    pairarr = pairline.split("\\|");
                                                    pipespair = pairarr[paircol];
                                                    break;
                                                }
                                                System.out.println("INC End of file reached...");
                                                System.exit(1);
                                                break;
                                            }
                                            pairline = pipesreader.readLine();
                                            if (pairline != null && !pairline.equals("|")) {
                                                pairarr = pairline.split("\\|");
                                                pipespair = pairarr[paircol];
                                                parlevel += StringUtils.countOccurrencesOf((String)pairarr[syntcolumn], (char)'(');
                                                parlevel -= StringUtils.countOccurrencesOf((String)pairarr[syntcolumn], (char)')');
                                                continue;
                                            }
                                            System.out.println("INC End of file/sentence reached...");
                                            System.exit(1);
                                        }
                                        if (modelpair.equals(pipespair)) {
                                            paired = true;
                                            inMultiword = false;
                                            continue;
                                        }
                                        if (!pipespair.contains("_")) continue;
                                        trypair = pipespair.substring(0, pipespair.indexOf(95));
                                        System.out.println("Try:" + trypair);
                                        if (!trypair.equals(modelpair)) continue;
                                        inMultiword = true;
                                        pipespair = pipespair.substring(pipespair.indexOf(95) + 1);
                                    }
                                    if (!(paired.booleanValue() || inMultiword.booleanValue() || modelpair.equals("\""))) {
                                        System.out.println("NOT!! Find next sentence");
                                        accomulatedsynt = "";
                                        while (pairline != null && !pairline.equals("|")) {
                                            pairline = pipesreader.readLine();
                                        }
                                        while (pairline != null && pairline.equals("|")) {
                                            pairline = pipesreader.readLine();
                                        }
                                        if (pairline != null) {
                                            pairarr = pairline.split("\\|");
                                            pipespair = pairarr[paircol];
                                        } else {
                                            System.out.println("End of file reached...");
                                            System.exit(1);
                                        }
                                        if (modelpair.equals(pipespair)) {
                                            paired = true;
                                            inMultiword = false;
                                        } else if (pipespair.contains("_")) {
                                            trypair = pipespair.substring(0, pipespair.indexOf(95));
                                            System.out.println("Try:" + trypair);
                                            if (trypair.equals(modelpair)) {
                                                inMultiword = true;
                                                pipespair = pipespair.substring(pipespair.indexOf(95) + 1);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    outfile.write(line);
                    if (pairpipes.getPipesDescArrCount() > 1) {
                        for (int i = 0; i < pairarr.length; ++i) {
                            if (i == paircol) continue;
                            if (paired.booleanValue() && pairarr != null) {
                                if (i == syntcolumn) {
                                    outfile.write("|" + accomulatedsynt + pairarr[i]);
                                    continue;
                                }
                                outfile.write("|" + pairarr[i]);
                                continue;
                            }
                            if (inMultiword.booleanValue() && pairarr != null) {
                                if (i == lemmacolumn) {
                                    if (!pairarr[i].contains("_")) {
                                        System.out.println("la caca maxima=" + pairarr[i]);
                                        System.exit(1);
                                    }
                                    outfile.write("|" + pairarr[i].substring(0, pairarr[i].indexOf(95)));
                                    pairarr[i] = pairarr[i].substring(pairarr[i].indexOf(95) + 1);
                                    continue;
                                }
                                if (i == syntcolumn) {
                                    if (pairarr[i].equals("*") || pairarr[i].equals("*)")) {
                                        outfile.write("|" + accomulatedsynt + "*");
                                        continue;
                                    }
                                    outfile.write("|" + accomulatedsynt + pairarr[i].substring(0, pairarr[i].lastIndexOf(42) + 1));
                                    pairarr[i] = pairarr[i].substring(pairarr[i].lastIndexOf(42));
                                    continue;
                                }
                                if (i >= pairpipes.getPipesDescArrCount()) {
                                    if (pairarr[i].equals("*")) {
                                        outfile.write("|*");
                                        continue;
                                    }
                                    outfile.write("|" + pairarr[i].substring(0, pairarr[i].lastIndexOf(42) + 1));
                                    pairarr[i] = pairarr[i].substring(pairarr[i].lastIndexOf(42));
                                    continue;
                                }
                                outfile.write("|-");
                                continue;
                            }
                            if (i >= pairpipes.getPipesDescArrCount()) {
                                outfile.write("|*");
                                continue;
                            }
                            if (i == syntcolumn) {
                                outfile.write("|" + accomulatedsynt + "-");
                                continue;
                            }
                            outfile.write("|-");
                        }
                        accomulatedsynt = "";
                    }
                    if (paired.booleanValue()) {
                        pairarr = null;
                        pairline = "";
                        pipespair = "";
                    }
                    outfile.write("\n");
                }
            }
            finally {
                if (modelreader != null) {
                    modelreader.close();
                }
                if (outfile != null) {
                    outfile.close();
                }
            }
        }
        catch (Exception e) {
            System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
                System.exit(1);
            }
            return null;
        }
        return outputfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pair2plain(String plainmodel) {
        String outputfile = this.getFile().toString() + ".pre";
        try {
            BufferedWriter outfile = new BufferedWriter(new FileWriter(outputfile));
            if (!this.isWellFormed.booleanValue()) {
                throw new Exception("Malformed pipes file");
            }
            int tokcolumn = this.getColumn("(tok|word).*");
            BufferedReader modelreader = new BufferedReader(new FileReader(plainmodel));
            BufferedReader pipesreader = new BufferedReader(new FileReader(this.f));
            try {
                String line;
                char cmodel = '\u0000';
                int offset = -1;
                boolean readmodel = true;
                while ((line = pipesreader.readLine()) != null) {
                    String[] linearr = line.split("\\|");
                    if (linearr.length >= this.pipes_desc_arr_count) {
                        String token = linearr[tokcolumn];
                        int token_offset = -1;
                        int token_leading_blanks = 0;
                        String paired_token = "";
                        for (int cn = 0; cn < token.length(); ++cn) {
                            char cpipes = token.charAt(cn);
                            if (readmodel) {
                                cmodel = (char)modelreader.read();
                                if (cmodel == '\uffffffff') {
                                    throw new Exception("Premature end of model file");
                                }
                                ++offset;
                            } else {
                                readmodel = true;
                            }
                            if (Character.toLowerCase(cpipes) == Character.toLowerCase(cmodel)) {
                                paired_token = paired_token + cmodel;
                                if (token_offset == -1) {
                                    token_offset = offset;
                                }
                                if (cmodel != 45 || cn != token.length() - 1 || (cmodel = (char)modelreader.read()) == -1) continue;
                                readmodel = false;
                                ++offset;
                                if (cmodel == '-') {
                                    --cn;
                                }
                                if (cmodel != ' ' && cmodel != '\n' && cmodel != '\r' && cmodel != 9) continue;
                                ++cn;
                                readmodel = true;
                                continue;
                            }
                            if (cmodel == ' ') {
                                --cn;
                                if (token_offset != -1) continue;
                                ++token_leading_blanks;
                                continue;
                            }
                            if (cmodel == '\"' && (cpipes == '`' || cpipes == '\'')) {
                                if (cn + 1 >= token.length() || cpipes != token.charAt(cn + 1)) continue;
                                cn += 2;
                                paired_token = paired_token + cmodel;
                                continue;
                            }
                            if ((cmodel == '\'' || cmodel == '`') && (cpipes == '`' || cpipes == '\'') || cmodel == '\u2014' || cmodel == '\u00a3') {
                                paired_token = paired_token + cmodel;
                                continue;
                            }
                            throw new Exception("Distinct chars offset=" + offset + " cmodel(" + cmodel + ") cpipes(" + cpipes + ")");
                        }
                        for (int i = 0; i < linearr.length - 1; ++i) {
                            if (i == tokcolumn) {
                                outfile.write(paired_token + "|" + token_leading_blanks + "|");
                                continue;
                            }
                            outfile.write(linearr[i] + "|");
                        }
                        outfile.write(linearr[linearr.length - 1] + "\n");
                        continue;
                    }
                    if (Character.toLowerCase(cmodel) != '\n' && Character.toLowerCase(cmodel) != '\r') {
                        cmodel = (char)modelreader.read();
                        if (cmodel != '\uffff') {
                            ++offset;
                            if (Character.toLowerCase(cmodel) != '\n' && Character.toLowerCase(cmodel) != '\r') {
                                throw new Exception("End of line not found (n) offset=" + offset + ". cmodel(" + cmodel + ") found instead.");
                            }
                            if (Character.toLowerCase(cmodel) == '\r' && (cmodel = (char)modelreader.read()) != '\uffff') {
                                ++offset;
                                if (Character.toLowerCase(cmodel) != '\n') {
                                    throw new Exception("End of line not found (rn)offset=" + offset + ". cmodel(" + cmodel + ") found instead.");
                                }
                            }
                        }
                    } else if (Character.toLowerCase(cmodel) == '\r' && (cmodel = (char)modelreader.read()) != '\uffff') {
                        ++offset;
                        if (Character.toLowerCase(cmodel) != '\n') {
                            throw new Exception("End of line not found (rn) offset=" + offset + ". cmodel(" + cmodel + ") found instead.");
                        }
                    }
                    outfile.write(line + "\n");
                }
            }
            finally {
                if (pipesreader != null) {
                    pipesreader.close();
                }
                if (modelreader != null) {
                    modelreader.close();
                }
                if (outfile != null) {
                    outfile.close();
                }
            }
        }
        catch (Exception e) {
            System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
                System.exit(1);
            }
            return null;
        }
        return outputfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String merge_tok_n_xml(String tmlfile, String root_tag, String elements_re, String attribs_re, String mergeattrib) {
        String outputfile = this.getFile().toString() + "-annotationKey";
        if (!elements_re.equals(".*")) {
            outputfile = outputfile + "-" + elements_re;
        }
        if (!attribs_re.equals(".*")) {
            outputfile = outputfile + "-" + attribs_re.replaceAll("([.]?\\*|[\"=])", "").replace('|', '_');
        }
        if (mergeattrib != null) {
            outputfile = outputfile + "-" + mergeattrib;
        }
        try {
            BufferedWriter outfile = new BufferedWriter(new FileWriter(outputfile));
            if (!this.isWellFormed.booleanValue()) {
                throw new Exception("Malformed pipes file");
            }
            int tokcolumn = this.getColumn("(token|word).*");
            int last_desc_column = this.getLastDescColumn();
            boolean hasRoot_tag = false;
            char cxml = '\u0000';
            String tag = "";
            String attribs = "-";
            String inTag = "";
            String inAttribs = "-";
            int BIO = 79;
            BufferedReader xmlreader = new BufferedReader(new FileReader(tmlfile));
            BufferedReader pipesreader = new BufferedReader(new FileReader(this.f));
            try {
                String line;
                while (true) {
                    if ((cxml = (char)xmlreader.read()) == '\uffffffff') {
                        throw new Exception("Premature end of model file");
                    }
                    if (cxml != '<') continue;
                    cxml = (char)xmlreader.read();
                    if (cxml == '\uffffffff') {
                        throw new Exception("Premature end of model file");
                    }
                    do {
                        tag = tag + cxml;
                        cxml = (char)xmlreader.read();
                        if (cxml != '\uffffffff') continue;
                        throw new Exception("Premature end of model file");
                    } while (cxml != '>');
                    if (tag.equalsIgnoreCase(root_tag)) break;
                    tag = "";
                }
                hasRoot_tag = true;
                if (!hasRoot_tag) {
                    throw new Exception("Root tag " + root_tag + " not found");
                }
                tag = "";
                cxml = '\u0000';
                while ((line = pipesreader.readLine()) != null) {
                    String[] linearr = line.split("\\|");
                    if (linearr.length >= this.pipes_desc_arr_count) {
                        String token = linearr[tokcolumn];
                        boolean interTokenTag = false;
                        boolean findtokenIter = false;
                        boolean delayed_closing = false;
                        int prevxmlchar = 120;
                        for (int cn = 0; cn < token.length(); ++cn) {
                            char cpipes = token.charAt(cn);
                            prevxmlchar = cxml;
                            cxml = (char)xmlreader.read();
                            if (cxml == '\uffffffff') {
                                throw new Exception("Premature end of model file");
                            }
                            if (Character.toLowerCase(cpipes) == Character.toLowerCase(cxml)) continue;
                            if (cxml == ' ' || cxml == '\n' || cxml == '\r' || cxml == '\t') {
                                --cn;
                                continue;
                            }
                            if (cxml == '<') {
                                if (cn != 0) {
                                    interTokenTag = true;
                                }
                                --cn;
                                while ((cxml = (char)xmlreader.read()) != '\uffff' && cxml != '>') {
                                    tag = tag + cxml;
                                }
                                if ((tag = tag.trim()).indexOf(32) != -1) {
                                    attribs = tag.substring(tag.indexOf(32) + 1);
                                    tag = tag.substring(0, tag.indexOf(32));
                                }
                                if (tag.matches("(?i)" + elements_re) && !tag.startsWith("/")) {
                                    findtokenIter = true;
                                    if (interTokenTag) {
                                        System.err.println("Inter-token (" + cn + ") tag consider manual tokenizing: " + token);
                                    }
                                    if (!inTag.equals("")) {
                                        throw new Exception("Nested tags (" + tag + "/" + inTag + ") consider manual correction");
                                    }
                                    inTag = tag;
                                    inAttribs = attribs;
                                    tag = "";
                                    attribs = "-";
                                    BIO = 66;
                                    if (!inAttribs.matches("(?i)" + attribs_re)) {
                                        BIO = 79;
                                        inTag = "";
                                        inAttribs = "-";
                                        findtokenIter = false;
                                        interTokenTag = false;
                                    }
                                    if (mergeattrib != null) {
                                        String tmpattrib = inAttribs.substring(inAttribs.indexOf(mergeattrib + "=")).substring(mergeattrib.length() + 1);
                                        if ((tmpattrib = tmpattrib.replace("\"", "")).indexOf(32) != -1) {
                                            tmpattrib = tmpattrib.substring(0, tmpattrib.indexOf(32));
                                        }
                                        inTag = inTag + "+" + tmpattrib;
                                    }
                                } else {
                                    interTokenTag = false;
                                }
                                if (tag.matches("/.*")) {
                                    String check = inTag;
                                    if (mergeattrib != null && inTag.matches(".+\\+.+")) {
                                        check = inTag.substring(0, inTag.indexOf(43));
                                    }
                                    if (tag.matches("/(?i)" + check)) {
                                        if (findtokenIter) {
                                            if (cn >= 0) {
                                                System.err.println("Inter Token end of tag (" + inTag + ") cn=" + cn + " " + line);
                                                delayed_closing = true;
                                            } else {
                                                BIO = 79;
                                                inTag = "";
                                                inAttribs = "-";
                                                findtokenIter = false;
                                                interTokenTag = false;
                                            }
                                        } else {
                                            BIO = 79;
                                            inTag = "";
                                        }
                                    }
                                }
                                if (tag.matches("/(?i)" + root_tag)) {
                                    System.err.println("closing root_tag=" + root_tag);
                                }
                                tag = "";
                                attribs = "-";
                                continue;
                            }
                            if (cxml == '&' || prevxmlchar == 38 && cxml == 'a') {
                                --cn;
                                while ((cxml = (char)xmlreader.read()) != '\uffff' && cxml != ';') {
                                    if (System.getProperty("DEBUG") == null || !System.getProperty("DEBUG").equalsIgnoreCase("true")) continue;
                                    System.err.println("Reading XML escaped char in: " + token);
                                }
                                continue;
                            }
                            throw new Exception("Distinct chars cxml(" + cxml + ") cpipes(" + cpipes + ")");
                        }
                        for (int i = 0; i < linearr.length - 1; ++i) {
                            if (i == last_desc_column) {
                                outfile.write(linearr[i] + "|" + (char)BIO);
                                if (BIO != 79) {
                                    outfile.write("-" + inTag);
                                }
                                outfile.write("|" + inAttribs + "|");
                                if (BIO != 66) continue;
                                BIO = 73;
                                inAttribs = "-";
                                continue;
                            }
                            outfile.write(linearr[i] + "|");
                        }
                        if (linearr.length - 1 == last_desc_column) {
                            outfile.write(linearr[linearr.length - 1] + "|" + (char)BIO);
                            if (BIO != 79) {
                                outfile.write("-" + inTag);
                            }
                            outfile.write("|" + inAttribs);
                            if (BIO == 66) {
                                BIO = 73;
                                inAttribs = "-";
                            }
                        } else {
                            outfile.write(linearr[linearr.length - 1]);
                        }
                        if (delayed_closing) {
                            BIO = 79;
                            inTag = "";
                            inAttribs = "-";
                            findtokenIter = false;
                            interTokenTag = false;
                            delayed_closing = false;
                        }
                        outfile.write("\n");
                        continue;
                    }
                    if (!inTag.equals("")) {
                        throw new Exception("Broken tag: " + inTag + " at the end of the file/sentence");
                    }
                    outfile.write(line + "\n");
                }
            }
            finally {
                if (pipesreader != null) {
                    pipesreader.close();
                }
                if (xmlreader != null) {
                    xmlreader.close();
                }
                if (outfile != null) {
                    outfile.close();
                }
            }
        }
        catch (Exception e) {
            System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
                System.exit(1);
            }
            return null;
        }
        return outputfile;
    }

    public static String IOB2check(PipesFile pipesfile) {
        return PipesFile.IOB2check(pipesfile, pipesfile.getLastDescColumn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String IOB2check(PipesFile pipesfile, int IOB2column) {
        String outputfile = null;
        try {
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                System.err.println("Cheking IOB2...");
            }
            outputfile = pipesfile.getFile().getCanonicalPath() + "-IOB2checked";
            BufferedWriter outfile = new BufferedWriter(new FileWriter(outputfile));
            BufferedReader pipesreader = new BufferedReader(new FileReader(pipesfile.getFile()));
            try {
                String pipesline;
                String[] pipesarr = null;
                String previousIOB2 = "O";
                int linen = 0;
                String previousSENT = "O";
                int toknumcol = pipesfile.getColumn("tok-num");
                int sentnumcol = pipesfile.getColumn("sent-num");
                while ((pipesline = pipesreader.readLine()) != null) {
                    ++linen;
                    pipesarr = pipesline.split("\\|");
                    if (sentnumcol != -1 && !pipesarr[sentnumcol].equals(previousSENT) || sentnumcol != -1 && pipesarr[toknumcol].matches("[^-]+-[^n]*n.*")) {
                        previousIOB2 = "O";
                    }
                    if (pipesarr.length > 1 && previousIOB2.equals("O") && pipesarr[IOB2column].startsWith("I-")) {
                        int i = 0;
                        for (i = 0; i < pipesarr.length - 1; ++i) {
                            if (i != IOB2column) {
                                outfile.write(pipesarr[i] + "|");
                                continue;
                            }
                            outfile.write(pipesarr[i].replaceFirst("I-", "B-") + "|");
                        }
                        if (i == IOB2column) {
                            outfile.write(pipesarr[i].replaceFirst("I-", "B-"));
                        } else {
                            outfile.write(pipesarr[i]);
                        }
                        outfile.write("\n");
                        previousIOB2 = "B";
                    } else {
                        outfile.write(pipesline + "\n");
                        previousIOB2 = pipesarr.length > 1 ? pipesarr[IOB2column].substring(0, 1) : "O";
                    }
                    if (sentnumcol == -1) continue;
                    previousSENT = pipesarr[sentnumcol];
                }
            }
            finally {
                if (pipesreader != null) {
                    pipesreader.close();
                }
                if (outfile != null) {
                    outfile.close();
                }
            }
        }
        catch (Exception e) {
            System.err.println("Errors found (TempEval):\n\t" + e.toString() + "\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
                System.exit(1);
            }
            return null;
        }
        return outputfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String merge_pipes(String primary, String secondary) {
        String outputfile = null;
        if (primary == null && secondary == null) {
            return null;
        }
        if (primary == null) {
            return secondary;
        }
        if (secondary == null) {
            return primary;
        }
        try {
            outputfile = primary + "-merged";
            BufferedWriter outfile = new BufferedWriter(new FileWriter(outputfile));
            BufferedReader extentsreader = new BufferedReader(new FileReader(primary));
            BufferedReader extentsreader2 = new BufferedReader(new FileReader(secondary));
            try {
                String extentline;
                String[] extentarr = null;
                String[] extentarr2 = null;
                PipesFile keypipes = new PipesFile();
                keypipes.loadFile(new File(primary));
                keypipes.isWellFormedOptimist();
                int iob2col1 = keypipes.getColumn("element\\(IOB2\\)");
                keypipes = new PipesFile();
                keypipes.loadFile(new File(secondary));
                keypipes.isWellFormedOptimist();
                int iob2col2 = keypipes.getColumn("element\\(IOB2\\)");
                boolean firstO = true;
                while ((extentline = extentsreader.readLine()) != null) {
                    extentarr = extentline.split("\\|");
                    String extentline2 = extentsreader2.readLine();
                    if (extentline2 == null) {
                        throw new Exception("Secondary file ended prematurely.");
                    }
                    extentarr2 = extentline2.split("\\|");
                    if (!extentarr[iob2col1].equals("O") && !extentarr2[iob2col2].equals("O")) {
                        System.err.println("Error merging pipes files!! overlaping elements.\n" + extentline + "\n" + extentline2);
                        System.err.println("Ignoring event");
                    }
                    if (!extentarr[iob2col1].equals("O")) {
                        if (iob2col1 == extentarr.length - 1) {
                            outfile.write(extentline + "|-\n");
                        } else {
                            outfile.write(extentline + "\n");
                        }
                        firstO = true;
                        continue;
                    }
                    if (firstO && extentarr2[iob2col2].startsWith("I-")) {
                        String tmpelem = extentarr2[iob2col2].substring(2);
                        extentline2 = extentline2.replaceAll("\\|I-" + tmpelem, "\\|B-" + tmpelem);
                    }
                    if (iob2col2 == extentarr2.length - 1) {
                        outfile.write(extentline2 + "|-\n");
                    } else {
                        outfile.write(extentline2 + "\n");
                    }
                    firstO = false;
                }
            }
            finally {
                if (extentsreader != null) {
                    extentsreader.close();
                }
                if (extentsreader2 != null) {
                    extentsreader2.close();
                }
                if (outfile != null) {
                    outfile.close();
                }
            }
        }
        catch (Exception e) {
            System.err.println("Errors found (TempEval):\n\t" + e.toString() + "\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
                System.exit(1);
            }
            return null;
        }
        return outputfile;
    }

    public int getColumn(String colname_re) {
        try {
            for (int i = 0; i < this.pipes_desc_arr_count; ++i) {
                if (!this.pipes_desc_arr[i].matches(colname_re)) continue;
                return i;
            }
        }
        catch (Exception e) {
            System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
                System.exit(1);
            }
            return -1;
        }
        return -1;
    }

    public int getLastDescColumn() {
        return this.pipes_desc_arr_count - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveColumnFile(String colname) {
        String outputfile = this.getFile().getAbsolutePath() + "." + colname;
        int col = this.getColumn(colname);
        try {
            BufferedWriter outfile = new BufferedWriter(new FileWriter(outputfile));
            if (!this.isWellFormed.booleanValue()) {
                throw new Exception("Malformed pipes file");
            }
            BufferedReader pipesreader = new BufferedReader(new FileReader(this.f));
            try {
                String line;
                String outputline = "";
                int current_sentence = 0;
                while ((line = pipesreader.readLine()) != null) {
                    String[] linearr = line.split("\\|");
                    if (linearr.length >= this.pipes_desc_arr_count) {
                        outfile.write(linearr[col] + "\n");
                        continue;
                    }
                    ++current_sentence;
                    outfile.write(outputline + "\n");
                    outputline = "";
                }
                if (!outputline.equals("")) {
                    outfile.write(outputline + "\n");
                }
            }
            finally {
                if (pipesreader != null) {
                    pipesreader.close();
                }
                if (outfile != null) {
                    outfile.close();
                }
            }
        }
        catch (Exception e) {
            System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
                System.exit(1);
            }
            return null;
        }
        return outputfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillStats(Stat st, String params) {
        block7: {
            try {
                BufferedReader pipesreader = new BufferedReader(new FileReader(this.f));
                try {
                    String line;
                    while ((line = pipesreader.readLine()) != null) {
                        String[] linearr = line.split("\\|");
                        if (linearr.length < this.pipes_desc_arr_count) continue;
                        st.addData(linearr);
                    }
                }
                finally {
                    if (pipesreader != null) {
                        pipesreader.close();
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
                if (System.getProperty("DEBUG") == null || !System.getProperty("DEBUG").equalsIgnoreCase("true")) break block7;
                e.printStackTrace(System.err);
                System.exit(1);
            }
        }
    }

    public String getStats(String parameters) {
        throw new UnsupportedOperationException("Not supported yet. IT HAS TO BE GENERIC. TOKEN ORIENTED. IF LAST COL HAS ELEMENTS THEN ALSO ELEMENT-ORIENTED");
    }
}

