import os
import timeit
from operator import itemgetter

import nltk
import splitter as splitter
import sqlalchemy
from scipy.stats import pearsonr
from sklearn.dummy import DummyClassifier, DummyRegressor
from sklearn.feature_selection import SelectKBest, f_regression
from sklearn.utils import random
from sklearn import svm,model_selection
import pickle
import re
import os
from pandas.plotting import scatter_matrix
import pandas as pd
import numpy as np
import scipy
import math
from sklearn.metrics import make_scorer
import splitter

from CTestGeneratorStrategy import CTestGeneratorStrategy


class GapSizeStrategy(CTestGeneratorStrategy):
    '''
    This is a implemenation of a ctest generation startegy called "Gap Size".
    This Strategy generates c-tests with calculated gap sizes to adjust to the
    the desired proficiency level and gets returned.
    '''
    file_inc = 'model_inc'
    file_dec = 'model_dec'


    def generateContextSents(self,ctest, sentence):
        '''
        This method appends a sentece which should not be mutilated by gaps in the DKPro TC Format.
        :param ctest:Token-List of ctest in DKPro TC format
        :param sentence: Sentece to add
        :return:List with added sentece
        '''
        token = nltk.word_tokenize(sentence)
        if not ctest:
            if len(token) > 20:
                [ctest.append(t + "\n") for t in token[-20:]]
            else:
                [ctest.append(t + "\n") for t in token]
        else:
            if len(token) > 20:
                [ctest.append(t + "\n") for t in token[:20]]
            else:
                [ctest.append(t + "\n") for t in token]
        ctest.append("----\n")


    def clean(self,l1,l2,inc):
        '''
        This method produces the difference between two predictions.
G
        :param l1:first gap prediction
        :param l2:second gap prediction
        :param inc:Booflean if second is increased gap of first
        :return:Difference of the gaps
        '''
        if inc:
            if l1<0:l1=0
            elif l1>1:l1=1
            if l2<0:l2=0
            elif l2>1:l2=1
            x=l1-l2
            return x
        else:
            if l1<0:l1=0
            elif l1>1:l1=1
            if l2<0:l2=0
            elif l2>1:l2=1
            x=l1-l2
            return x


    def gap_candidates(self,word,pos,dictf):
        '''
          This method produces the number of alternative Solution to a gap by considring its prefix.
          :param word: Word which is mutilated by the gap
          :param pos: Position of the last visible gap character
          :param dictf: Dictinary file to search for the alternatives
          :return: Number of alternative gap candidates
        '''
        r = re.compile('^('+word[:pos+1]+'\w{'+str(len(word)-(pos+1))+'})$')#+'\w{'+str(len(word)-(pos+2))+","+str(len(word)-pos)+'})$')
        newlist = list(filter(r.match, dictf))
        if len(newlist)>0:return len(newlist)
        else: return 0


    def generate_vector_dict(self,wordlist):
        '''
        This method generates a dictionary containing all occuring character in the words of the wordlist.
        The value of the character key is always the position of the dict entry if it is represented as a verctor.
        We can use this dict later on to manually vectorize character since strings are not supported by th scykit learn regresseion.
        :param wordlist: Words that can occur
        :return: Dictionary which maps character to its vector position
        '''
        print('Wordlist-Length:',len(wordlist))
        convert = {}
        for word in wordlist:
            for char in word:
                if char not in convert:
                    convert.update({char: len(convert)})
                    print(len(convert))
        print(convert)
        with open('VectorDict.pickle', 'wb') as handle:
            pickle.dump(convert, handle, protocol=pickle.HIGHEST_PROTOCOL)



    def annotate(self,word,pos,dictf,convert,increase):
        """
        This method annotates features for the prediction of the influence of a gap character increase or decrease of a prefix.
        Therefore, it
        :param word:word of the gap
        :param pos: position of the last visible character after the change
        :param dictf: Dictionary of the exercise language
        :param convert: Dictionary of all possible character
        :param increase: Boolean if the word gets increased
        :return:List of Feature Values
        """
        # vectorization of the changing character
        features = []
        vect1 = [0] * len(convert)
        vect1[convert[word[int(pos)]]]=1
        features.extend(vect1)
        # Length of the word
        features.append(len(word))
        #Length of the gap
        features.append(len(word)-int(pos)-1)
        # Is Referential gap after change

        if word[:int(pos)+1].lower()=="th":
            features.append(True)
        else:features.append(False)

        #Logarithmic number of gap candidate difference

        if increase:
            x=self.gap_candidates(word, int(pos)-1, dictf)
            y=self.gap_candidates(word, int(pos), dictf)
            if y==0:x=0
            if abs(x-y)==0:features.append(0)
            else:features.append(math.log(abs(x-y),2))
        else:
            x=self.gap_candidates(word, int(pos)+1, dictf)
            y=self.gap_candidates(word, int(pos), dictf)
            if y==0:x=0

            if abs(x - y) == 0:features.append(0)
            else:features.append(math.log(abs(x-y),2))
        return features

    def scorer_pearson_r(self,estim,x,y):
        return pearsonr(estim.predict(x),y)[0]


    def train_svm(self):
        """
        Trains two svms to predict the difference in the gap difficulty prediction of a gap if the gap gets increased or decreased.
        The svm increase predicts the effect of the prefix increase and the svm decrease predicts the effect of the gap incease.
        Furthermore, the svms are evaluated on a three fold corss validation after their training.
        :return: The svms, saved in a pickle file.
        """
        engine = sqlalchemy.create_engine('sqlite:///ctest_generator_data.db', echo=True)
        fname = os.environ['DKPRO_HOME'] + '/dictionaries/american-english'

        file = open(fname, "r")
        dictf=file.readlines()
        handle= open('VectorDict.pickle', 'rb')
        convert = pickle.load(handle)
        #print('Length of Convert:',len(convert))
        connection = engine.connect()
        table = connection.execute("SELECT * FROM GapSizeCharUpdate")
        keys=connection.execute("SELECT * FROM GapSizeCharUpdate").keys()
        table = list(table)
        model = svm.SVR()
        Xinc=[]
        Yinc=[]
        Xdec=[]
        Ydec=[]
        print(keys)
        for i,r in enumerate(table):
            position_char=int(len(r['gap'])/ 2)-1+float(r["level"])#Aktuelle Position
            if float(r["level"])>=0 and i+1< len(table):
                full = position_char==len(r['gap'])-1 # True if no gap is left


                #Abstand von vorigem zu diesem element
                Y=self.clean(float(r["gapScore"]),float(table[i+1]["gapScore"]),True)
                Yinc.append(Y)
                #Prediction von vorigem
                X = [table[i + 1][9]]# Prediction Score
                #Annotation von aktuellem element
                Xinc.append(X+self.annotate(r['gap'].lower(),position_char,dictf,convert,True))

            elif i+1< len(table) and float(table[i+1]["level"])<0:
                # abstand von diesem zu naechstem element
                Y=self.clean(float(table[i+1]["gapScore"]),float(r["gapScore"]),False)
                Ydec.append(Y)
                #Wir befinden uns auf diesem -> Annotation
                X = [r[9]]# Prediction Score
                #Annotate naechste Zeile (was passiert wenn kleiner?
                Xdec.append(X+self.annotate(table[i+1]['gap'].lower(),position_char-1,dictf,convert,False))


        avg_inc=sum(Yinc) / len(Yinc)
        '''
        dummy = DummyRegressor(strategy="constant",constant=avg_inc)
        score=model_selection.cross_val_score(dummy, Xinc, Yinc,scoring='neg_mean_squared_error')
        print('RMSE Inc Baseline:',math.sqrt(abs(sum(score)/3)))
        score = model_selection.cross_val_score(dummy, Xinc, Yinc, scoring=self.scorer_pearson_r)
        print('r Inc Baseline:', sum(score) / 3)
        '''
        score=model_selection.cross_val_score(model, Xinc, Yinc,scoring='neg_mean_squared_error')
        print('RMSE Inc:',math.sqrt(abs(sum(score)/3)))
        score = model_selection.cross_val_score(model, Xinc, Yinc, scoring=self.scorer_pearson_r)
        print('r Inc:', sum(score) / 3)

        model.fit(Xinc, Yinc)
        pickle.dump(model, open(self.file_inc, 'wb'))

        avg_dec = sum(Ydec) / len(Ydec)
        '''
        dummy = DummyRegressor(strategy="constant",constant=avg_dec)
        score = model_selection.cross_val_score(dummy, Xdec, Ydec, scoring='neg_mean_squared_error')
        print('RMSE Dec Baseline:', math.sqrt(abs(sum(score)/3)))
        score = model_selection.cross_val_score(dummy, Xdec, Ydec, scoring=self.scorer_pearson_r)
        print('r Dec Baseline:', sum(score) / 3)
        '''
        score = model_selection.cross_val_score(model, Xdec, Ydec, scoring='neg_mean_squared_error')
        print('MSE Dec:', math.sqrt(abs(sum(score)/3)))
        score = model_selection.cross_val_score(model, Xdec, Ydec, scoring=self.scorer_pearson_r)
        print('r Dec:', sum(score) / 3)
        model.fit(Xdec, Ydec)
        pickle.dump(model, open(self.file_dec, 'wb'))
        connection.close()

    def generate_ctest(self, txt,adjust):
        '''
        This method generates a ctest in the DKPro TC Format according to the gap size strategy.
        The startegy suggests to generate a ctest containing always 20 gaps with one candidate in between.
        Furthermore are the gap sizes of these gaps instructed by the adjust parameter to adjust the test difficulty.
        Candidates are all normal words with more than two character.
        The first and the last sentece have no mutilations to provide context information.
        :param txt: Text to produce ctest from
        :param adjust: Dictionary of changes to the normal 50% gap sizes number of characters added or removed from the prefix
                        The key is the gap Id
        :return: None if text is not appropriate for the test generation or
        ctest in TC Format and human readable ctest and all gap words as tuple if successful
        '''
        ctest_tc = []
        ctest =[]
        gaps=[]
        gapId = 0;
        tN = 0
        sents = [s.replace("\n", "") for s in nltk.sent_tokenize(txt)[:30]]

        if len(sents) < 2:
            print("input should contain at least 2 sentences, but only ", len(sents), "were detected")
            return

        self.generateContextSents(ctest_tc, sents[0])
        ctest.append(sents[0])

        for n, sent in enumerate(sents[1:]):
            if sents[n + 1] == None or gapId > 19:
                self.generateContextSents(ctest_tc, sent)
                ctest.append(sent)
                return ("".join(ctest_tc),"".join(ctest),gaps)
            else:
                for i, t in enumerate(nltk.word_tokenize(sent)):
                    if t.isalpha() and not t.isupper() and len(t) > 1:
                        if tN % 2 == 1 and not gapId > 19:
                            cut = int(len(t) / 2)
                            if gapId in adjust:
                                cut=cut+adjust[gapId]
                            ctest_tc.append(t + "\t" + str(gapId+1) + "\t" + t[0:cut] + "\t" + "0.0" + "\n")
                            ctest.append(" "+t[0:cut]+"_"*(len(t)-cut))
                            gapId += 1
                            gaps.append(t)
                        else:
                            ctest_tc.append(t + "\n")
                            ctest.append(" "+t)
                        tN += 1
                    else:
                        ctest_tc.append(t + "\n")

                        if t not in [".",",","\'",'\'','?','!',';','&','(',')']:
                            ctest.append(" "+t)
                        else:
                            ctest.append(t)
                ctest_tc.append("----\n")
        return None

    def predict_gaps(self,features,model,adjust,dictf,convert,incease,stored):
        """
        This method predicts the difficulty change of all gaps if the size is changed by one character.
        It only calculates each gap size change once by carrying a list of all former and not used persued gap change predictions.
        :param features:List of gap information needed to predict the gap feature values for all gaps
        :param model:the prediction model
        :param adjust: Dict of all gap adjustments from the normal 50% gap size
        :param dictf: Dictionary with words of the text language
        :param convert: Dictionary to verctorize character
        :param incease: Boolean of the direction of the gap adjustment
        :param stored: list of all predictions, which have not changed since the last iteration
        :return:Dictionary of all gap change predictions in one direction(Increase or Decrease)
        """
        for n, line in enumerate(features):
            if n not in stored:
                if incease:
                    cut = int(len(line[1]) / 2)
                else:
                    cut = int(len(line[1]) / 2) -2
                if n in adjust:
                    cut = cut + adjust[n]
                x = [line[0]] + self.annotate(line[1].lower(), cut, dictf, convert, True)
                stored[n]= model.predict([x])[0]
        return stored


    def increase_ctest(self,features,delta,model,text,adjust,dictf,convert):
        """
        This method adjust the difficulty of the c-test by increasing certain c-test gap prefix.
        It chooses always the most effective gap increased based on a prediction of the estimated effect.
        It stops when the estimated gap difference is bigger than the difference of the test to the desired difficulty.
        :param features:List of gap information needed to predict the gap feature values for all gaps
        :param delta:Average Difference of the desired difficulty and the difficulty of the current c-test
        :param model:prediction model of the gap change differences of individual gap difficulties
        :param text:text to build the c-test from
        :param adjust:Dict of all gap size adjustments
        :param dictf:Dict of words of the test language
        :param convert: Dict to convert a character into a boolean vector
        :return:tuple of the resulting c-test and all gap adjustments as dict
        """
        stored= self.predict_gaps(features, model, adjust, dictf, convert, True, {})

        while delta > 0:
            #Filter all gap changes which are not desired
            for key,value in sorted(stored.items(), key=itemgetter(1)):
                if -value / 20 > delta:
                    stored[key]=0
                if key in adjust:
                        length = int(len(features[key][1]) / 2) + adjust[key] + 1
                else:length = int(len(features[key][1]) / 2)+1
                if  length >= len(features[key][1]):
                        stored[key] = 0

            pot_candidates=[t for t in stored.items() if t[1]!=0 and t[1]<0]
            if len(pot_candidates) == 0: break
            mi = min(pot_candidates, key=itemgetter(1))[0]#Max bei decrease
            delta += stored[mi]/20
            #charakter hinzufuegen
            if mi in adjust:
                adjust[mi]+=1
            else:adjust[mi]=1
            del stored[mi]#To calculate it new

            stored = self.predict_gaps(features, model, adjust, dictf, convert, True, stored)
        return (self.generate_ctest(text, adjust),adjust)


    def decrease_ctest(self,features,delta,model,text,adjust,dictf,convert):
        """
        This method adjust the difficulty of the c-test by decreasing certain c-test gap prefix.
        It chooses always the most effective gap increased based on a prediction of the estimated effect.
        It stops when the estimated gap difference is bigger than the difference of the test to the desired difficulty.
        :param features:List of gap information needed to predict the gap feature values for all gaps
        :param delta:Average Difference of the desired difficulty and the difficulty of the current c-test
        :param model:prediction model of the gap change differences of individual gap difficulties
        :param text:text to build the c-test from
        :param adjust:Dict of all gap size adjustments
        :param dictf:Dict of words of the test language
        :param convert: Dict to convert a character into a boolean vector
        :return:tuple of the resulting c-test and all gap adjustments as dict
        """
        stored= self.predict_gaps(features, model, adjust, dictf, convert, True, {})

        while delta < 0:
            #Filter all gap changes which are not desired
            for key,value in sorted(stored.items(), key=itemgetter(1)):
                if value / 20 > -delta:
                    stored[key]=0
                if key in adjust:
                        length = int(len(features[key][1]) / 2) + adjust[key] - 1
                else:length = int(len(features[key][1]) / 2)- 1
                if  length <= 0:
                        stored[key] = 0

            pot_candidates=[t for t in stored.items() if t[1]!=0 and t[1]>0]
            if len(pot_candidates) == 0: break
            mi = max(pot_candidates, key=itemgetter(1))[0]
            delta += stored[mi]/20
            #charakter hinzufuegen
            if mi in adjust:
                adjust[mi]-=1
            else:adjust[mi]=-1
            del stored[mi]#To calculate it new

            stored = self.predict_gaps(features, model, adjust, dictf, convert, True, stored)
        return (self.generate_ctest(text, adjust),adjust)



    def retrieve_ctest(self):
        '''
        Main Method to use this strategy!
        This method produces a c-test with the desired difficulty level. Therefore it uses only one prediction iteration
         of the c-test prediction system of the java system and one iteration of the internal adjustment process.
        :return:ctest as tuple of tc-Format, Human readable, gaps, the average and the individual predicted difficulty.
        '''
        fname = os.environ['DKPRO_HOME'] + '/dictionaries/american-english'

        file = open(fname, "r")
        dictf = file.readlines()
        handle = open('VectorDict.pickle', 'rb')
        convert = pickle.load(handle)

        if os.path.getsize(self.file_inc) > 0:
            file1 = open(self.file_inc, 'rb')
            model_inc = pickle.load(file1)
        else:
            print("model file inc is empty")
            return
        if os.path.getsize(self.file_dec) > 0:
            file2 = open(self.file_dec, 'rb')
            model_dec = pickle.load(file2)
        else:
            print("model file dec is empty")
            return
        start = timeit.default_timer()
        text=self.texts[0]
        adjust={}
        ctestTemp = self.generate_ctest(text,{})
        ind=0
        while ctestTemp is not None:
            ind+=1
            prediction = self.predict(ctestTemp[0])
            if self.evaluator(prediction[0],self.targetLevel)[0]==0 or ind==2:
                print("Test generation took", timeit.default_timer() - start)
                return ctestTemp+(sum(prediction[0])/len(prediction[0]),prediction[0],)
            else:
                delta =self.evaluator(prediction[0],self.targetLevel)
                if delta[0]> 0:
                    r= self.increase_ctest(list(zip(prediction[0], ctestTemp[2])), delta[0], model_inc, text,adjust,dictf,convert)
                    ctestTemp=r[0]
                    adjust=r[1]

                else:
                    r = self.decrease_ctest(list(zip(prediction[0], ctestTemp[2])), delta[0], model_dec, text, adjust ,dictf, convert)
                    ctestTemp = r[0]
                    adjust = r[1]

        print("Problem during the generation: cTest became None")
        return False

