#ifndef _graphcjj1L_DEPPARSER_H
#define _graphcjj1L_DEPPARSER_H

#include <vector>
#include <unordered_set>

#include "common/parser/depgraph.h"
#include "graphcjj1L_state.h"
#include "graphcjj1L_weight.h"
#include "common/parser/depparser_base.h"

#include <include/learning/tree/lca.h>

namespace graph_merging {
class graph_decomposer_tg;
class graph_decomposer_gg;
class graph_DDdecoder_tree_graph;
}

namespace graph_merging_1L{
class graph_DDdecoder_tree_graph;
class graph_DDdecoder_graph_graph;
}

namespace graphcjj1L {
	class DepParser : public DepParserBase {
	private:
		static WordPOSTag empty_taggedword;
		static WordPOSTag start_taggedword;
		static WordPOSTag end_taggedword;

		StateItem m_lItems[MAX_SENTENCE_SIZE][MAX_SENTENCE_SIZE];
		WordPOSTag m_lSentence[MAX_SENTENCE_SIZE];
		std::vector<PCLArc> m_vecCorrectArcs;
		std::vector<PCLArc> m_vecTrainArcs;
		int m_nSentenceLength;

		DependencyTree m_vecDependencyTree;
		LCA m_lcaTree;

		tscore m_nRetval;
		tscore m_lFirstOrderScore[MAX_SENTENCE_SIZE << 1];

		int m_nDis, m_nDir,m_nLabel;

		Word p_word, c_word;
		POSTag p_tag, c_tag;

		WordInt word_int;
		POSTagInt tag_int;

		POSTag p_1_tag, p1_tag, c_1_tag, c1_tag, b_tag;
		Word p_1_word, p1_word, c_1_word, c1_word;

		TwoWordsInt word_word_int;
		POSTagSet2Int tag_tag_int;
		WordPOSTagInt word_tag_int;

		POSTagSet3Int tag_tag_tag_int;
		WordPOSTagPOSTagInt word_tag_tag_int;
		POSTagSet4Int flag_word_tag_tag_int;
		POSTagSet3Int flag_tag_tag_int;
		WordWordPOSTagInt word_word_tag_int;

		POSTagSet4Int tag_tag_tag_tag_int;
		WordWordPOSTagPOSTagInt word_word_tag_tag_int;
		PathInt path_int;
		POSTagInt subcat_int;
		POSTagSet2Int subcat_tag_int,path_tag_int;
		LabelInt label_int;

		std::unordered_set<BiGram<int>> m_setFirstGoldScore;

		void update();
		void generate(DependencyGraph * retval, const DependencyGraph & correct);
		void goldCheck();
		void debug_arc();
		tscore arcScore(const int & p, const int & c, const int & label);

		void getOrUpdateStackScore(const int & p, const int & c, const int & label, const int & amount = 0);

	public:
		tscore Score[MAX_SENTENCE_SIZE][MAX_SENTENCE_SIZE][MAX_LABEL_SIZE][2];
		DepParser(const std::string & sFeatureInput, const std::string & sFeatureOut, int nState);
		~DepParser();
		void outans();
		void decode() override;
		void decodeArcs() override;
		void getArc(int l, int r);
		void train(const DependencyGraph & correct, const int & round);
		void parse(const Sentence & sentence, DependencyGraph * retval);
		void work(DependencyGraph * retval, const DependencyGraph & correct);
		void work_after_scoring(const Sentence & sentence, DependencyGraph * retval);
		void decode_after_scoring();
		friend class graph_merging::graph_decomposer_tg;
		friend class graph_merging::graph_decomposer_gg;
		friend class graph_merging::graph_DDdecoder_tree_graph;
		friend class graph_merging_1L::graph_DDdecoder_tree_graph;
		friend class graph_merging_1L::graph_DDdecoder_graph_graph;
	};
}

#endif
