/*
 * Decompiled with CFR 0.152.
 */
package fig.html;

import fig.basic.IOUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;

public class HtmlWriter {
    PrintWriter out;

    public HtmlWriter(PrintWriter out) {
        this.out = out;
    }

    public void includeScript(String ... scriptFiles) {
        String[] stringArray = scriptFiles;
        int n = scriptFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            this.out.println("<script src=\"" + file + "\"></script>");
            ++n2;
        }
    }

    public void begin(String title) {
        this.begin(title, null, true);
    }

    public void begin(String title, String bodyAttr, boolean printHeader) {
        this.out.println("<html>");
        this.out.println("<head>");
        this.out.println("<title>" + title + "</title>");
        if (printHeader) {
            this.out.println("<h1>" + title + "</h1>");
        }
        this.out.println("</head>");
        this.out.println("<body" + (bodyAttr != null ? " " + bodyAttr : "") + ">");
    }

    public void end() {
        this.out.println("</body>");
        this.out.println("</html>");
    }

    public static String redirect(String url, int time) {
        return String.format("<meta http-equiv=\"refresh\" content=\"%s; url=%s\">", time, url);
    }

    public static String msgLoc(String loc) {
        return "<table><tr><td><div id=\"" + loc + "\"/></td></tr></table>";
    }

    public static String msg(String text, String loc, String msg, boolean hide) {
        String hideStr = "";
        if (hide) {
            hideStr = " onMouseOut=\"hidetext('" + loc + "')\"";
        }
        return String.format("<div onMouseOver=\"showtext('%s','%s')\"%s>%s</div>", loc, msg, hideStr, text);
    }

    public static String color(String text, String color) {
        return "<font color=\"" + color + "\">" + text + "</font>";
    }

    public static String link(String text, String url) {
        return "<a href=\"" + url + "\">" + text + "</a>";
    }

    public static String tag(String tag, String text) {
        return "<" + tag + ">" + text + "</" + tag + ">";
    }

    public static String bold(String text) {
        return HtmlWriter.tag("b", text);
    }

    public static String underline(String text) {
        return HtmlWriter.tag("u", text);
    }

    public static String img(String url) {
        return "<img src=\"" + url + "\"/>";
    }

    public void writeFile(String file) {
        try {
            String line;
            BufferedReader in = IOUtils.openIn(file);
            while ((line = in.readLine()) != null) {
                this.out.println(line);
            }
        }
        catch (IOException e) {
            this.printLine("Failed to read " + file + ": " + e);
        }
    }

    public void printBlock(String id, String title, String contents) {
        this.out.println("<div id='" + id + "'>");
        this.out.println("<div>");
        this.out.println(HtmlWriter.bold(title));
        this.out.println("</div>");
        this.out.println("<div>");
        this.out.println(contents);
        this.out.println("</div>");
        this.out.println("</div>");
    }

    public PrintWriter getWriter() {
        return this.out;
    }

    public void println(Object obj) {
        this.out.println(obj);
    }

    public void printLine(Object obj) {
        this.out.println(obj + "<br>");
    }

    public void flush() {
        this.out.flush();
    }

    public void newParagraph() {
        this.out.println("<p>");
    }
}

