/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.dualdecomp;

import de.bwaldvogel.liblinear.Feature;
import de.bwaldvogel.liblinear.FeatureNode;
import de.bwaldvogel.liblinear.Linear;
import de.bwaldvogel.liblinear.Model;
import de.bwaldvogel.liblinear.Parameter;
import de.bwaldvogel.liblinear.Problem;
import de.bwaldvogel.liblinear.SolverType;
import edu.pku.coli.pear.dag.PredicateArgumentAdjunctDAG;
import edu.pku.coli.pear.dag.SentenceForDAGParsing;
import fig.basic.Indexer;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SimpleClassificationDecoder {
    Indexer<IntsWrapper> featIndexer = new Indexer();
    PrintWriter pw;
    List<Double> vy = new ArrayList<Double>();
    List<Feature[]> vx = new ArrayList<Feature[]>();
    Model model;
    Parameter param = new Parameter(SolverType.L2R_L2LOSS_SVC_DUAL, 1.0, Double.POSITIVE_INFINITY, 0.1);

    public SimpleClassificationDecoder() {
        this.featIndexer.getIndex(new IntsWrapper(new int[0]));
        try {
            this.pw = new PrintWriter("liblinear.trn");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void train(List<SentenceForDAGParsing> sents) {
        this.extractSamples(sents);
        Problem prob = SimpleClassificationDecoder.constructProblem(this.vy, this.vx, this.featIndexer.size(), -1.0);
        this.vy = new ArrayList<Double>();
        this.vx = new ArrayList<Feature[]>();
        this.model = Linear.train((Problem)prob, (Parameter)this.param);
    }

    public SentenceForDAGParsing decode(SentenceForDAGParsing s) {
        int sentLen = s.numOfWords();
        PredicateArgumentAdjunctDAG dag = new PredicateArgumentAdjunctDAG(sentLen);
        int i = 0;
        while (i <= sentLen) {
            int j = 1;
            while (j <= sentLen) {
                Feature[] feats = this.extractFeatures(i, j, s);
                double label = Linear.predict((Model)this.model, (Feature[])feats);
                if (label == 1.0) {
                    dag.addArc(i, j, "X");
                }
                ++j;
            }
            ++i;
        }
        s.setPredictedDAG(dag);
        return s;
    }

    private void extractSamples(List<SentenceForDAGParsing> sents) {
        int n = 0;
        for (SentenceForDAGParsing s : sents) {
            if (++n % 500 == 0) {
                System.out.print(".");
            }
            int sentLen = s.numOfWords();
            PredicateArgumentAdjunctDAG dag = s.getGoldDAG();
            int i = 0;
            while (i <= sentLen) {
                int j = 1;
                while (j <= sentLen) {
                    if (dag.containsArc(i, j)) {
                        this.extractSample(i, j, s, 1);
                    } else {
                        this.extractSample(i, j, s, 0);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void extractSample(int from, int to, SentenceForDAGParsing s, int label) {
        this.vy.add(Double.valueOf(label));
        Feature[] feats = this.extractFeatures(from, to, s);
        this.vx.add(feats);
    }

    private Feature[] extractFeatures(int from, int to, SentenceForDAGParsing s) {
        ArrayList<IntsWrapper> intsFeats = new ArrayList<IntsWrapper>();
        int wordFrom = s.getKthWordIndex(from);
        int posFrom = s.getKthPosIndex(from);
        int preWordFrom = s.getKthWordIndex(from - 1);
        int prePosFrom = s.getKthPosIndex(from - 1);
        int postWordFrom = s.getKthWordIndex(from + 1);
        int postPosFrom = s.getKthPosIndex(from + 1);
        int wordTo = s.getKthWordIndex(to);
        int posTo = s.getKthPosIndex(to);
        int preWordTo = s.getKthWordIndex(to - 1);
        int prePosTo = s.getKthPosIndex(to - 1);
        int postWordTo = s.getKthWordIndex(to + 1);
        int postPosTo = s.getKthPosIndex(to + 1);
        int dist = from - to;
        int n = 42;
        intsFeats.add(new IntsWrapper(new int[]{n++, wordFrom, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, posFrom, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, wordFrom, posFrom, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, wordTo, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, posTo, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, wordTo, posTo, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, preWordFrom, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, prePosFrom, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, preWordFrom, prePosFrom, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, postWordFrom, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, postPosFrom, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, postWordFrom, postPosFrom, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, preWordTo, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, prePosTo, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, preWordTo, prePosTo, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, postWordTo, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, postPosTo, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, postWordTo, postPosTo, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, wordFrom, posFrom, wordTo, posTo, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, wordFrom, posFrom, wordTo, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, wordFrom, posFrom, posTo, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, wordFrom, wordTo, posTo, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, posFrom, wordTo, posTo, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, wordFrom, wordTo, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, posFrom, posTo, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, wordFrom, posFrom, prePosFrom, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, posFrom, preWordFrom, prePosFrom, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, posFrom, prePosFrom, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, wordFrom, posFrom, postPosFrom, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, posFrom, postWordFrom, postPosFrom, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, posFrom, postPosFrom, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, wordTo, posTo, prePosTo, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, posTo, preWordTo, prePosTo, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, posTo, prePosTo, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, wordTo, posTo, postPosTo, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, posTo, postWordTo, postPosTo, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, posTo, postPosTo, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, wordTo, posTo, prePosFrom, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, posTo, preWordFrom, prePosFrom, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, posTo, prePosFrom, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, wordTo, posTo, postWordFrom, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, posTo, postWordFrom, postPosFrom, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, posTo, postPosFrom, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, wordFrom, posFrom, prePosTo, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, posFrom, preWordTo, prePosTo, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, posFrom, prePosTo, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, wordFrom, posFrom, postPosTo, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, posFrom, postWordTo, postPosTo, dist}));
        intsFeats.add(new IntsWrapper(new int[]{n++, posFrom, postPosTo, dist}));
        ArrayList<Integer> intFeats = new ArrayList<Integer>();
        for (IntsWrapper feat : intsFeats) {
            intFeats.add(this.featIndexer.getIndex(feat));
        }
        Collections.sort(intFeats);
        Feature[] feats = new Feature[intFeats.size()];
        int i = 0;
        while (i < intFeats.size()) {
            feats[i] = new FeatureNode(((Integer)intFeats.get(i)).intValue(), 1.0);
            ++i;
        }
        return feats;
    }

    static Problem constructProblem(List<Double> vy, List<Feature[]> vx, int max_index, double bias) {
        Problem prob = new Problem();
        prob.bias = bias;
        prob.l = vy.size();
        prob.n = max_index;
        if (bias >= 0.0) {
            ++prob.n;
        }
        prob.x = new Feature[prob.l][];
        int i = 0;
        while (i < prob.l) {
            prob.x[i] = vx.get(i);
            if (bias >= 0.0) {
                assert (prob.x[i][prob.x[i].length - 1] == null);
                prob.x[i][prob.x[i].length - 1] = new FeatureNode(max_index + 1, bias);
            }
            ++i;
        }
        prob.y = new double[prob.l];
        i = 0;
        while (i < prob.l) {
            prob.y[i] = vy.get(i);
            ++i;
        }
        return prob;
    }

    public static class IntsWrapper {
        int[] ints;

        public IntsWrapper(int[] ints) {
            this.ints = ints;
        }

        public int hashCode() {
            return Arrays.hashCode(this.ints);
        }

        public boolean equals(Object o) {
            if (!(o instanceof IntsWrapper)) {
                return false;
            }
            IntsWrapper other = (IntsWrapper)o;
            return Arrays.equals(this.ints, other.ints);
        }
    }
}

