/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.dualdecomp;

import edu.pku.coli.dualdecomp.AbstractDecoder;
import edu.pku.coli.pear.dag.PredicateArgumentAdjunctDAG;
import edu.pku.coli.pear.dag.SentenceForDAGParsing;
import fig.basic.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class PredicateCentricWithNumOfArgsDecoder
extends AbstractDecoder {
    private static final long serialVersionUID = 4169854071583855254L;

    public PredicateCentricWithNumOfArgsDecoder() {
        this(10);
    }

    public PredicateCentricWithNumOfArgsDecoder(int maxSib) {
        this.featureExtractor = new FeatureExtractor();
        this._maxSibling = maxSib;
    }

    @Override
    public SentenceForDAGParsing toDAGSentence(SentenceForDAGParsing sent, int[][] var) {
        int sentLen = sent.numOfWords();
        PredicateArgumentAdjunctDAG sys = new PredicateArgumentAdjunctDAG(sentLen);
        int i = 0;
        while (i <= sentLen) {
            int j = 0;
            while (j < sentLen) {
                if (var[i][j] == 1) {
                    sys.addArc(i, j + 1, "X");
                }
                ++j;
            }
            ++i;
        }
        sent.setPredictedDAG(sys);
        return sent;
    }

    @Override
    public int[][] toVariable(SentenceForDAGParsing sent) {
        int sentLen = sent.numOfWords();
        int[][] var = new int[sentLen + 1][sentLen];
        PredicateArgumentAdjunctDAG dag = sent.getGoldDAG();
        for (Pair<Integer, Integer> arc : dag.toUnlabeledPairs()) {
            var[arc.getFirst().intValue()][arc.getSecond().intValue() - 1] = 1;
        }
        return var;
    }

    @Override
    public int[][] decodeVariable(final SentenceForDAGParsing sent, final float[] param, final double[][] additionalWeight) {
        final FeatureExtractor fe = (FeatureExtractor)this.featureExtractor;
        int sentLen = sent.numOfWords();
        int[][] var = new int[sentLen + 1][sentLen];
        double totalScore = 0.0;
        int maxSibling = Math.min(sent.numOfWords(), this._maxSibling);
        int i = 0;
        while (i <= sentLen) {
            int k;
            double maxScore = Double.NEGATIVE_INFINITY;
            double[][] scoresWithoutN = new double[sentLen + 1][sentLen + 1];
            ExecutorService es = Executors.newFixedThreadPool(this.threadNum);
            ExecutorCompletionService<Double> group = new ExecutorCompletionService<Double>(es);
            Future[][] resultsWithoutN = new Future[sentLen + 1][sentLen + 1];
            int j = 0;
            while (j <= sentLen) {
                k = j;
                while (k <= sentLen) {
                    final int fi = i;
                    final int fj = j;
                    final int fk = k;
                    resultsWithoutN[j][k] = group.submit(new Callable<Double>(){

                        @Override
                        public Double call() {
                            return fe.scoreSiblings(fi, fj, fk + 1, sent, additionalWeight, param);
                        }
                    });
                    ++k;
                }
                ++j;
            }
            es.shutdown();
            j = 0;
            while (j <= sentLen) {
                k = j;
                while (k <= sentLen) {
                    try {
                        scoresWithoutN[j][k] = (Double)resultsWithoutN[j][k].get();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    catch (ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                    ++k;
                }
                ++j;
            }
            int n = 0;
            while (n <= maxSibling) {
                double score = 0.0;
                score += fe.scoreNumOfSibling(i, n, sent, param);
                double[][] scores = new double[sentLen + 1][sentLen + 1];
                double[][] table = new double[n][sentLen];
                int[][] bp = new int[n][sentLen];
                int last = -1;
                if (n != 0) {
                    int k2;
                    es = Executors.newFixedThreadPool(this.threadNum);
                    group = new ExecutorCompletionService(es);
                    Future[][] results = new Future[sentLen + 1][sentLen + 1];
                    int j2 = 0;
                    while (j2 <= sentLen) {
                        k2 = j2;
                        while (k2 <= sentLen) {
                            final int fi = i;
                            final int fn = n;
                            final int fj = j2;
                            final int fk = k2;
                            results[j2][k2] = group.submit(new Callable<Double>(){

                                @Override
                                public Double call() {
                                    return fe.scoreSiblings(fi, fn, fj, fk + 1, sent, param);
                                }
                            });
                            ++k2;
                        }
                        ++j2;
                    }
                    es.shutdown();
                    j2 = 0;
                    while (j2 <= sentLen) {
                        k2 = j2;
                        while (k2 <= sentLen) {
                            try {
                                scores[j2][k2] = scoresWithoutN[j2][k2] + (Double)results[j2][k2].get();
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                            catch (ExecutionException e) {
                                throw new RuntimeException(e);
                            }
                            ++k2;
                        }
                        ++j2;
                    }
                    int k3 = 1;
                    while (k3 <= sentLen - n + 1) {
                        table[0][k3 - 1] = scores[0][k3 - 1];
                        ++k3;
                    }
                    j2 = 1;
                    while (j2 < n) {
                        k2 = j2 + 1;
                        while (k2 < sentLen - n + j2 + 2) {
                            double max = Double.NEGATIVE_INFINITY;
                            int l = j2;
                            while (l < k2) {
                                double s = table[j2 - 1][l - 1] + scores[l][k2 - 1];
                                if (s > max) {
                                    max = s;
                                    bp[j2][k2 - 1] = l - 1;
                                }
                                ++l;
                            }
                            table[j2][k2 - 1] = max;
                            ++k2;
                        }
                        ++j2;
                    }
                    double max = Double.NEGATIVE_INFINITY;
                    int k4 = n + 1;
                    while (k4 <= sentLen) {
                        double s = table[n - 1][k4 - 1] + scores[k4][sentLen];
                        if (s > max) {
                            max = s;
                            last = k4 - 1;
                        }
                        ++k4;
                    }
                    score += max;
                }
                if (score > maxScore) {
                    maxScore = score;
                    int j3 = 0;
                    while (j3 < sentLen) {
                        var[i][j3] = 0;
                        ++j3;
                    }
                    if (n != 0) {
                        var[i][last] = 1;
                        j3 = n - 1;
                        while (j3 > 0) {
                            last = bp[j3][last];
                            var[i][last] = 1;
                            --j3;
                        }
                    }
                }
                ++n;
            }
            totalScore += maxScore;
            ++i;
        }
        return var;
    }

    @Override
    public int[][] decodeAfterScoring(double[][] additionalWeight) {
        return null;
    }

    @Override
    public void scoreFeats(float[] param) {
    }

    class FeatureExtractor
    extends AbstractDecoder.FeatureExtractor {
        private static final long serialVersionUID = -4447534434468649991L;

        FeatureExtractor() {
        }

        @Override
        List<Integer> extract(SentenceForDAGParsing sent, boolean predicted) {
            ArrayList<Integer> ret = new ArrayList<Integer>();
            int sentLen = sent.numOfWords();
            PredicateArgumentAdjunctDAG dag = sent.getGoldDAG();
            if (predicted) {
                dag = sent.getPredictedDAG();
            }
            int i = 0;
            while (i <= sentLen) {
                PredicateArgumentAdjunctDAG.PredicateArgumentAdjunctArcAdjacencyList arcs = dag.getAdjacencyLists()[i];
                List<PredicateArgumentAdjunctDAG.ArcInfo> outArcs = arcs.getOutArcs();
                ret.addAll(this.numOfSiblingFeats(i, outArcs.size(), sent));
                if (!outArcs.isEmpty()) {
                    ret.addAll(this.siblingFeats(i, 0, outArcs.get((int)0).index, sent));
                    ret.addAll(this.siblingFeats(i, outArcs.size(), 0, outArcs.get((int)0).index, sent));
                    int j = 1;
                    while (j < outArcs.size()) {
                        ret.addAll(this.siblingFeats(i, outArcs.get((int)(j - 1)).index, outArcs.get((int)j).index, sent));
                        ret.addAll(this.siblingFeats(i, outArcs.size(), outArcs.get((int)(j - 1)).index, outArcs.get((int)j).index, sent));
                        ++j;
                    }
                    ret.addAll(this.siblingFeats(i, outArcs.get((int)(outArcs.size() - 1)).index, sentLen + 1, sent));
                    ret.addAll(this.siblingFeats(i, outArcs.size(), outArcs.get((int)(outArcs.size() - 1)).index, sentLen + 1, sent));
                }
                ++i;
            }
            return ret;
        }

        public List<Integer> numOfSiblingFeats(int head, int numOfSibling, SentenceForDAGParsing sent) {
            ArrayList<Integer> ret = new ArrayList<Integer>();
            int n = 42;
            int headWord = sent.getKthWordIndex(head);
            int headPos = sent.getKthWordIndex(head);
            int preHeadWord = sent.getKthWordIndex(head - 1);
            int postHeadWord = sent.getKthWordIndex(head + 1);
            int preHeadPos = sent.getKthPosIndex(head - 1);
            int postHeadPos = sent.getKthPosIndex(head + 1);
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, numOfSibling, headWord));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, numOfSibling, headPos));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, numOfSibling, headWord, headPos));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, numOfSibling, preHeadWord));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, numOfSibling, preHeadPos));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, numOfSibling, preHeadWord, preHeadPos));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, numOfSibling, postHeadWord));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, numOfSibling, postHeadPos));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, numOfSibling, postHeadWord, postHeadPos));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, numOfSibling, headWord, headPos, preHeadWord, preHeadPos));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, numOfSibling, headWord, headPos, preHeadPos));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, numOfSibling, headPos, preHeadWord, preHeadPos));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, numOfSibling, headPos, preHeadPos));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, numOfSibling, headWord, headPos, postHeadWord, postHeadPos));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, numOfSibling, headWord, headPos, postHeadPos));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, numOfSibling, headPos, postHeadWord, postHeadPos));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, numOfSibling, headPos, postHeadPos));
            return ret;
        }

        public double scoreNumOfSibling(int head, int numOfSibling, SentenceForDAGParsing sent, float[] param) {
            return PredicateCentricWithNumOfArgsDecoder.this.score(this.numOfSiblingFeats(head, numOfSibling, sent), param);
        }

        public List<Integer> siblingFeats(int head, int prev, int cur, SentenceForDAGParsing sent) {
            ArrayList<Integer> ret = new ArrayList<Integer>();
            int n = 1024;
            int headWord = sent.getKthWordIndex(head);
            int headPos = sent.getKthWordIndex(head);
            int preHeadWord = sent.getKthWordIndex(head - 1);
            int postHeadord = sent.getKthWordIndex(head + 1);
            int preHeadPos = sent.getKthPosIndex(head - 1);
            int postHeadPos = sent.getKthPosIndex(head + 1);
            int curWord = sent.getKthWordIndex(cur);
            int curPos = sent.getKthPosIndex(cur);
            int preCurWord = sent.getKthWordIndex(cur - 1);
            int postCurWord = sent.getKthWordIndex(cur + 1);
            int preCurPos = sent.getKthPosIndex(cur - 1);
            int postCurPos = sent.getKthPosIndex(cur + 1);
            int prevWord = sent.getKthWordIndex(prev);
            int prevPos = sent.getKthPosIndex(prev);
            int prePrevWord = sent.getKthWordIndex(prev - 1);
            int postPrevWord = sent.getKthWordIndex(prev + 1);
            int prePrevPos = sent.getKthPosIndex(prev - 1);
            int postPrevPos = sent.getKthPosIndex(prev + 1);
            int distCur = head - cur;
            int distCurPrev = cur - prev;
            int distPrev = head - prev;
            int order = distCur > 0 ? 1 : (distPrev < 0 ? 2 : 3);
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curWord, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curWord, curPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, distCurPrev));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, distCurPrev));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, prevPos, distCurPrev));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, prevPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, preHeadWord, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, preHeadPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, preHeadWord, preHeadPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, preCurWord, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, preCurPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, preCurWord, preCurPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prePrevWord, distCurPrev));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prePrevPos, distCurPrev));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prePrevWord, prePrevPos, distCurPrev));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, postHeadord, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, postHeadPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, postHeadord, postHeadPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, postCurWord, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, postCurPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, postCurWord, postCurPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, postPrevWord, distCurPrev));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, postPrevPos, distCurPrev));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, postPrevWord, postPrevPos, distCurPrev));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, preHeadWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, preHeadPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, preHeadWord, preHeadPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, preCurWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, preCurPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, preCurWord, preCurPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prePrevWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prePrevPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prePrevWord, prePrevPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, postHeadord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, postHeadPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, postHeadord, postHeadPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, postCurWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, postCurPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, postCurWord, postCurPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, postPrevWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, postPrevPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, postPrevWord, postPrevPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, curWord, curPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, curWord, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, curPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, curWord, curPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, curWord, curPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, curWord, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, curPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, prevPos, curWord, curPos, distCurPrev));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, prevPos, curWord, distCurPrev));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, prevPos, curPos, distCurPrev));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, curWord, curPos, distCurPrev));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, curWord, curPos, distCurPrev));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, curWord, distCurPrev));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, curPos, distCurPrev));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, curWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, curWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, curWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, prevPos, curWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, prevPos, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, prevPos, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, curWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, curWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, preHeadWord, preHeadPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, preHeadPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, preHeadWord, preHeadPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, preHeadPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, postHeadord, postHeadPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, postHeadPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, postHeadord, postHeadPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, postHeadPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, preHeadWord, preHeadPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, preHeadPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, preHeadWord, preHeadPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, preHeadPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, postHeadord, postHeadPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, postHeadPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, postHeadord, postHeadPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, postHeadPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curWord, curPos, preCurWord, preCurPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curWord, curPos, preCurPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curPos, preCurWord, preCurPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curPos, preCurPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curWord, curPos, postCurWord, postCurPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curWord, curPos, postCurPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curPos, postCurWord, postCurPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curPos, postCurPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curWord, curPos, preCurWord, preCurPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curWord, curPos, preCurPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curPos, preCurWord, preCurPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curPos, preCurPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curWord, curPos, postCurWord, postCurPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curWord, curPos, postCurPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curPos, postCurWord, postCurPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curPos, postCurPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curWord, curPos, preHeadWord, preHeadPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curWord, curPos, preHeadPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curPos, preHeadWord, preHeadPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curPos, preHeadPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curWord, curPos, postHeadord, postHeadPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curWord, curPos, postHeadPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curPos, postHeadord, postHeadPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curPos, postHeadPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curWord, curPos, preHeadWord, preHeadPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curWord, curPos, preHeadPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curPos, preHeadWord, preHeadPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curPos, preHeadPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curWord, curPos, postHeadord, postHeadPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curWord, curPos, postHeadPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curPos, postHeadord, postHeadPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curPos, postHeadPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, preCurWord, preCurPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, preCurPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, preCurWord, preCurPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, preCurPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, postCurWord, postCurPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, postCurPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, postCurWord, postCurPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, postCurPos, distCur));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, preCurWord, preCurPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, preCurPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, preCurWord, preCurPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, preCurPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, postCurWord, postCurPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, postCurPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, postCurWord, postCurPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, postCurPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, prevWord, prevPos, curWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, prevWord, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, prevWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, prevPos, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, prevPos, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, prevWord, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, prevWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, prevPos, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, prevPos, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, preCurWord, preCurPos, curWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, preCurWord, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, preCurWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, preCurPos, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, preCurPos, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, preCurWord, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, preCurWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, preCurPos, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, preCurPos, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, postCurWord, postCurPos, curWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, postCurWord, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, postCurWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, postCurPos, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, postCurPos, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, postCurWord, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, postCurWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, postCurPos, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, postCurPos, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, preHeadWord, preHeadPos, curWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, preHeadWord, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, preHeadWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, preHeadPos, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, preHeadPos, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, preHeadWord, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, preHeadWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, preHeadPos, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, preHeadPos, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, postHeadord, postHeadPos, curWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, postHeadord, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, postHeadord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, postHeadPos, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, postHeadPos, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, postHeadord, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, postHeadord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, postHeadPos, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, postHeadPos, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, prevPos, preCurWord, preCurPos, curWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, preCurWord, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, preCurWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, preCurPos, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, preCurPos, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, preCurWord, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, preCurWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, preCurPos, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, preCurPos, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, prevPos, postCurWord, postCurPos, curWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, postCurWord, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, postCurWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, postCurPos, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, postCurPos, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, postCurWord, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, postCurWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, postCurPos, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, postCurPos, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, prevPos, prePrevWord, prePrevPos, curWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, prePrevWord, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, prePrevWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, prePrevPos, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, prePrevPos, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, prePrevWord, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, prePrevWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, prePrevPos, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, prePrevPos, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, prevPos, postPrevWord, postPrevPos, curWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, postPrevWord, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, postPrevWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, postPrevPos, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, postPrevPos, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, postPrevWord, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, postPrevWord, curPos, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, postPrevPos, curWord, order));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, postPrevPos, curPos, order));
            PredicateArgumentAdjunctDAG tree = sent.getSyntaxTree();
            if (PredicateCentricWithNumOfArgsDecoder.this.usePathFeat && tree != null && !tree.isEmpty() && cur <= sent.numOfWords()) {
                char p;
                int pos;
                PredicateArgumentAdjunctDAG.ArcInfo parentArc;
                ArrayList<Integer> curToRoot = new ArrayList<Integer>();
                ArrayList<Integer> headToRoot = new ArrayList<Integer>();
                int t = cur;
                while ((parentArc = tree.getOneParent(t)) != null) {
                    curToRoot.add(t);
                    t = parentArc.index;
                }
                curToRoot.add(t);
                t = head;
                while ((parentArc = tree.getOneParent(t)) != null) {
                    headToRoot.add(t);
                    t = parentArc.index;
                }
                headToRoot.add(t);
                int leastCommonAncestor = 1;
                while (leastCommonAncestor <= curToRoot.size() && leastCommonAncestor <= headToRoot.size() && curToRoot.get(curToRoot.size() - leastCommonAncestor) == headToRoot.get(headToRoot.size() - leastCommonAncestor)) {
                    ++leastCommonAncestor;
                }
                int pathPoss = n++;
                int pathP = n++;
                int i = 0;
                while (i <= curToRoot.size() - leastCommonAncestor) {
                    pos = sent.getKthPosIndex((Integer)curToRoot.get(i));
                    p = sent.getKthPos((Integer)curToRoot.get(i)).charAt(0);
                    pathPoss = 31 * pathPoss + pos;
                    pathP = 31 * pathP + p;
                    ++i;
                }
                pathPoss = -pathPoss;
                pathP = -pathP;
                if (leastCommonAncestor > 1) {
                    int pos2 = sent.getKthPosIndex((Integer)curToRoot.get(curToRoot.size() - leastCommonAncestor + 1));
                    char p2 = sent.getKthPos((Integer)curToRoot.get(curToRoot.size() - leastCommonAncestor + 1)).charAt(0);
                    pathPoss = 31 * pathPoss + pos2;
                    pathPoss = 31 * pathPoss + SentenceForDAGParsing.posIndexer.size();
                    pathP = 31 * pathP + p2;
                    pathP = 31 * pathP + 255;
                }
                i = headToRoot.size() - leastCommonAncestor;
                while (i >= 0) {
                    pos = sent.getKthPosIndex((Integer)headToRoot.get(i));
                    p = sent.getKthPos((Integer)headToRoot.get(i)).charAt(0);
                    pathPoss = 31 * pathPoss + pos;
                    pathP = 31 * pathP + p;
                    --i;
                }
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(pathPoss));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(pathP));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(pathPoss, distCur));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(pathP, distCur));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathPoss, headWord, headPos, curWord, curPos, distCur));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathPoss, headWord, headPos, curWord, distCur));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathPoss, headWord, headPos, curPos, distCur));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathPoss, headWord, curWord, curPos, distCur));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathPoss, headPos, curWord, curPos, distCur));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathPoss, headWord, curWord, distCur));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathPoss, headPos, curPos, distCur));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathP, headWord, headPos, curWord, curPos, distCur));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathP, headWord, headPos, curWord, distCur));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathP, headWord, headPos, curPos, distCur));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathP, headWord, curWord, curPos, distCur));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathP, headPos, curWord, curPos, distCur));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathP, headWord, curWord, distCur));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathP, headPos, curPos, distCur));
            }
            return ret;
        }

        public List<Integer> siblingFeats(int head, int numOfSibling, int prev, int cur, SentenceForDAGParsing sent) {
            ArrayList<Integer> ret = new ArrayList<Integer>();
            int n = 65536;
            int headWord = sent.getKthWordIndex(head);
            int headPos = sent.getKthWordIndex(head);
            int preHeadWord = sent.getKthWordIndex(head - 1);
            int postHeadord = sent.getKthWordIndex(head + 1);
            int preHeadPos = sent.getKthPosIndex(head - 1);
            int postHeadPos = sent.getKthPosIndex(head + 1);
            int curWord = sent.getKthWordIndex(cur);
            int curPos = sent.getKthPosIndex(cur);
            int preCurWord = sent.getKthWordIndex(cur - 1);
            int postCurWord = sent.getKthWordIndex(cur + 1);
            int preCurPos = sent.getKthPosIndex(cur - 1);
            int postCurPos = sent.getKthPosIndex(cur + 1);
            int prevWord = sent.getKthWordIndex(prev);
            int prevPos = sent.getKthPosIndex(prev);
            int prePrevWord = sent.getKthWordIndex(prev - 1);
            int postPrevWord = sent.getKthWordIndex(prev + 1);
            int prePrevPos = sent.getKthPosIndex(prev - 1);
            int postPrevPos = sent.getKthPosIndex(prev + 1);
            int distCur = head - cur;
            int distCurPrev = cur - prev;
            int distPrev = head - prev;
            int order = distCur > 0 ? 1 : (distPrev < 0 ? 2 : 3);
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, distCur, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, distCur, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, distCur, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curWord, distCur, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curPos, distCur, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curWord, curPos, distCur, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, distCurPrev, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, distCurPrev, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, prevPos, distCurPrev, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curWord, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curPos, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, curWord, curPos, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, prevPos, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, curWord, curPos, distCur, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, curWord, distCur, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, curPos, distCur, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, curWord, curPos, distCur, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, curWord, curPos, distCur, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, curWord, distCur, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, curPos, distCur, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, prevPos, curWord, curPos, distCurPrev, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, prevPos, curWord, distCurPrev, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, prevPos, curPos, distCurPrev, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, curWord, curPos, distCurPrev, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, curWord, curPos, distCurPrev, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, curWord, distCurPrev, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, curPos, distCurPrev, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, curWord, curPos, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, curWord, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, curPos, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, curWord, curPos, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, curWord, curPos, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, curWord, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, curPos, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, prevPos, curWord, curPos, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, prevPos, curWord, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, prevPos, curPos, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, curWord, curPos, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, curWord, curPos, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevWord, curWord, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, prevPos, curPos, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, headPos, prevWord, prevPos, curWord, curPos, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, prevWord, curWord, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, prevWord, curPos, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, prevPos, curWord, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headWord, prevPos, curPos, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, prevWord, curWord, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, prevWord, curPos, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, prevPos, curWord, order, numOfSibling));
            ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, headPos, prevPos, curPos, order, numOfSibling));
            PredicateArgumentAdjunctDAG tree = sent.getSyntaxTree();
            if (PredicateCentricWithNumOfArgsDecoder.this.usePathFeat && tree != null && !tree.isEmpty() && cur <= sent.numOfWords()) {
                char p;
                int pos;
                PredicateArgumentAdjunctDAG.ArcInfo parentArc;
                ArrayList<Integer> curToRoot = new ArrayList<Integer>();
                ArrayList<Integer> headToRoot = new ArrayList<Integer>();
                int t = cur;
                while ((parentArc = tree.getOneParent(t)) != null) {
                    curToRoot.add(t);
                    t = parentArc.index;
                }
                curToRoot.add(t);
                t = head;
                while ((parentArc = tree.getOneParent(t)) != null) {
                    headToRoot.add(t);
                    t = parentArc.index;
                }
                headToRoot.add(t);
                int leastCommonAncestor = 1;
                while (leastCommonAncestor <= curToRoot.size() && leastCommonAncestor <= headToRoot.size() && curToRoot.get(curToRoot.size() - leastCommonAncestor) == headToRoot.get(headToRoot.size() - leastCommonAncestor)) {
                    ++leastCommonAncestor;
                }
                int pathPoss = n++;
                int pathP = n++;
                int i = 0;
                while (i <= curToRoot.size() - leastCommonAncestor) {
                    pos = sent.getKthPosIndex((Integer)curToRoot.get(i));
                    p = sent.getKthPos((Integer)curToRoot.get(i)).charAt(0);
                    pathPoss = 31 * pathPoss + pos;
                    pathP = 31 * pathP + p;
                    ++i;
                }
                pathPoss = -pathPoss;
                pathP = -pathP;
                if (leastCommonAncestor > 1) {
                    int pos2 = sent.getKthPosIndex((Integer)curToRoot.get(curToRoot.size() - leastCommonAncestor + 1));
                    char p2 = sent.getKthPos((Integer)curToRoot.get(curToRoot.size() - leastCommonAncestor + 1)).charAt(0);
                    pathPoss = 31 * pathPoss + pos2;
                    pathPoss = 31 * pathPoss + SentenceForDAGParsing.posIndexer.size();
                    pathP = 31 * pathP + p2;
                    pathP = 31 * pathP + 255;
                }
                i = headToRoot.size() - leastCommonAncestor;
                while (i >= 0) {
                    pos = sent.getKthPosIndex((Integer)headToRoot.get(i));
                    p = sent.getKthPos((Integer)headToRoot.get(i)).charAt(0);
                    pathPoss = 31 * pathPoss + pos;
                    pathP = 31 * pathP + p;
                    --i;
                }
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(pathPoss, numOfSibling));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(pathP, numOfSibling));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(pathPoss, distCur, numOfSibling));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(pathP, distCur, numOfSibling));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathPoss, headWord, headPos, curWord, curPos, distCur, numOfSibling));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathPoss, headWord, headPos, curWord, distCur, numOfSibling));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathPoss, headWord, headPos, curPos, distCur, numOfSibling));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathPoss, headWord, curWord, curPos, distCur, numOfSibling));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathPoss, headPos, curWord, curPos, distCur, numOfSibling));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathPoss, headWord, curWord, distCur, numOfSibling));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathPoss, headPos, curPos, distCur, numOfSibling));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathP, headWord, headPos, curWord, curPos, distCur, numOfSibling));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathP, headWord, headPos, curWord, distCur, numOfSibling));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathP, headWord, headPos, curPos, distCur, numOfSibling));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathP, headWord, curWord, curPos, distCur, numOfSibling));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathP, headPos, curWord, curPos, distCur, numOfSibling));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathP, headWord, curWord, distCur, numOfSibling));
                ret.add(PredicateCentricWithNumOfArgsDecoder.this.hashInts(n++, pathP, headPos, curPos, distCur, numOfSibling));
            }
            return ret;
        }

        public double scoreSiblings(int headWordIndex, int numOfSibling, int prev, int cur, SentenceForDAGParsing sent, float[] param) {
            return PredicateCentricWithNumOfArgsDecoder.this.score(this.siblingFeats(headWordIndex, numOfSibling, prev, cur, sent), param);
        }

        public double scoreSiblings(int headWordIndex, int prev, int cur, SentenceForDAGParsing sent, double[][] additionalWeight, float[] param) {
            double score = PredicateCentricWithNumOfArgsDecoder.this.score(this.siblingFeats(headWordIndex, prev, cur, sent), param);
            if (cur <= sent.numOfWords()) {
                score += additionalWeight[headWordIndex][cur - 1];
            }
            return score;
        }
    }
}

