###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################


use Getopt::Std;

getopts("d");

$DEBUG = ($opt_d) ? 1 : 0;

sub debug {
  if ($DEBUG) {
    print stderr $_[0] , " " , $_[1], "\n";
  }
}


## for each tree...
while ( <> ) {

  # U|G add bars to all constituents
  s/\(([^ )(]+)/\(\1|\1/g;
#  # U|M|G add bars to all constituents
#  s/\(([^ )(]+)/\(\1|\1|\1/g;

  ## mark top-level constituent as current...
  s/^ *\((.*)\) *$/{\1}/;
  ## mark all other constituents as internal...
  s/\(/\[/g;
  s/\)/\]/g;
  ## for each constituent...
  while ( $_ =~ /{/ ) {
    ## mark all children of current...
    for ( $i=index($_,'{'),$d=0; $i<index($_,'}'); $i++ ) {
      if ( substr($_,$i,1)eq'[' ) { if($d==0){substr($_,$i,1)='<';} $d++; }
      if ( substr($_,$i,1)eq']' ) { $d--; if($d==0){substr($_,$i,1)='>';} }
    }
    #################### ADD SED RULES HERE: apply rules to angles (children) within braces (consituent)...
    debug(++$step, "   $_");

#    # U|A|G add bars to all constituents
#    s/{([^ |]*) (.*)}/{\1||\1 \2}/;
#    # U|G add bars to all constituents
#    s/{([^ |]*) (.*)}/{\1|\1 \2}/;
#    # add bar to root constituent
#    s/^{([^ ]*) (.*)}/{\1|\1 \2}/;
#    # add bar to left child constituents
#    s/\(([^ ]*) *{([^ ]*) (.*)}(.*)\)/\(\1 {\2|\2 \3}\4\)/;

    debug($step, " 0 $_");

    # U|G defer values from any node with matching attr, value in right child
    while ( s/{([^ |]*)(-[a-z]+)([^- |]+)(?=[-|])([^ ]*\|[^ ]*)\2\3([^ ]*) (.*)<([^ |]*)\2\3([^_ ]*\|[^ ]* [^>]*)> *}/{\1\2\%\4\2\3\5 \6<\7\2\3\8>}/ ) { debug($step," 1 $_"); }
#    # U|A|G defer values from any node with matching attr, value in right child
#    while ( s/{([^ |]*)(-[a-z]+)([^- |]+)(?=[-|])([^ ]*\|[^ ]*)\2([^- |]+)(?=[-|])([^ ]*\|[^ ]*)\2\5([^ ]* .*)<([^ |]*)\2\5([^_ ]*\|[^ ]* [^>]*)> *}/{\1\2\%\4\2\%\6\2\5\7<\8\2\%\9>}/ ) { debug($step," 1 $_"); }
#    while ( s/{([^ |]*)(-[a-z]+)([^- |]+)([^ ]*\|[^ ]*)\2([^- |]+)([^ ]*\|[^ ]*)\2\4([^ ]* .*)<([^ |]*)\2\4([^_ ]*\|[^ ]* [^>]*)> *}/{\1\2\%\4\2\%\6\2\4\7<\8\2\%\9>}/ ) { debug($step," 1 $_"); }
#    # U|C defer values from any node with matching attr, value in right child
#    while ( s/{([^ |]*)(-[a-z]+)([^- _|%]+)(?=[-| ])([^_|]*)\|([^|]*) (.*)<([^ |]*)\2\3([^_ ]* [^>]*)> *}/{\1\2\%\4|\5 \6<\7\2\3\8>}/ ) { debug($step," 1 $_"); }
#    # U|C defer values from any node with matching attr, value in right child
#    while ( s/{([^ |]*)(-[a-z]+)([^- _|%]+)(?=[-| ])([^_|]*)\|([^|]*) (.*)<([^ |]*)\2\3([^_ ]* [^>]*)> *}/{\1\2\%\4|\2\3\5 \6<\7\2\3\8>}/ ) { debug($step," 1 $_"); }
#    # U|U|C defer values from any node with matching attr, value in right child
#    while ( s/{([^ |]*)(-[a-z]+)([^- _|%]+)(?=[-| ])([^_|]*)\|([^|]*)\|([^ ]*) (.*)<([^ |]*)\2\3([^_ ]* [^>]*)> *}/{\1\2\%\4|\2\%\5|\2\3\6 \7<\8\2\3\9>}/ ) { debug($step," 1 $_"); }

#    # defer values from any left node that match attr in node's right child
#    while ( s/\(([^ ]*) +{([^ |]*)(-[a-z]+)([^- |%]+)(?=[-| ])([^_]*)|(.*)|(.*) (.*)<([^ |]*)\3\4([^_]* [^>]*)> *}(.*)\)/\($1 {$2$3\%$5|$6$3\%|$7$3$4 $8<$9$3$4$10>}$11\)/ ) { debug($step," 1 $_"); }
#    # defer values from any right node that match attr in node's right child and are deferred in node's parent
#    while ( s/\(([^ |]*)(-[a-z]+)\%(.*?) +{([^ |]*)\2([^- |%]+)(?=[-| ])([^_]* .*)<([^ |]*)\2\5([^_]* [^>]*)> *} *\)/\(\1\2\%\3 {\4\2\%\6<\7\2\5\8>}\)/ ) { debug($step," 2 $_");}
#    # defer values from left child that match in right child
#    while ( s/\(([^ ]*) +{([^ |]*)(-[a-z]+)([^- |%]+)(?=[-| ])([^_]* .*)<([^ |]*)\3\4([^_]* [^>]*)> *}(.*)\)/\(\1 {\2\3\%\5<\6\3\4\7>}\8\)/ ) { debug($step," 1 $_"); }
#    # defer values from right child that match in right child and are deferred in parent
#    while ( s/\(([^ |]*)(-[a-z]+)\%(.*?) +{([^ |]*)\2([^- |%]+)(?=[-| ])([^_]* .*)<([^ |]*)\2\5([^_]* [^>]*)> *} *\)/\(\1\2\%\3 {\4\2\%\6<\7\2\5\8>}\)/ ) { debug($step," 2 $_");}
    # remove duplicate % vars
    while ( s/-([^ ]*)\%-\1\%/-\1\%/ ) {}

    ####################
    ## mark current as external...
    s/{(.*?)}/\(\1\)/;
    ## mark first unexpanded child as current...
    s/<(.*?)>/{\1}/;
  }

  print $_;

}
