/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import org.maltparser.core.config.ConfigurationException;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.symbol.SymbolTable;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.core.syntaxgraph.Element;
import org.maltparser.core.syntaxgraph.edge.Edge;
import org.maltparser.core.syntaxgraph.node.DependencyNode;
import org.maltparser.core.syntaxgraph.node.TokenNode;
import org.maltparser.parser.AbstractParserFactory;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.ParserConfiguration;
import org.maltparser.parser.ParserState;
import org.maltparser.parser.SingleMalt;
import org.maltparser.parser.guide.ClassifierGuide;

public abstract class Algorithm {
    protected DependencyParserConfig manager;
    protected ClassifierGuide classifierGuide;
    protected ParserState parserState;
    protected ParserConfiguration currentParserConfiguration;
    protected boolean diagnostics = false;
    protected BufferedWriter diaWriter;

    public Algorithm(DependencyParserConfig manager) throws MaltChainedException {
        this.setManager(manager);
        this.setDiagnostics((Boolean)manager.getOptionValue("singlemalt", "diagnostics"));
        if (this.diagnostics) {
            this.openDiaWriter(manager.getOptionValue("singlemalt", "diafile").toString());
        }
    }

    public abstract void terminate() throws MaltChainedException;

    public boolean isDiagnostics() {
        return this.diagnostics;
    }

    public void setDiagnostics(boolean diagnostics) {
        this.diagnostics = diagnostics;
    }

    public BufferedWriter getDiaWriter() {
        return this.diaWriter;
    }

    public void writeToDiaFile(String message) throws MaltChainedException {
        try {
            this.getDiaWriter().write(message);
        }
        catch (IOException e) {
            throw new MaltChainedException("Could not write to the diagnostic file. ", e);
        }
    }

    public void closeDiaWriter() throws MaltChainedException {
        if (this.diaWriter != null) {
            try {
                this.diaWriter.flush();
                this.diaWriter.close();
            }
            catch (IOException e) {
                throw new MaltChainedException("Could not close the diagnostic file. ", e);
            }
        }
    }

    public void openDiaWriter(String fileName) throws MaltChainedException {
        if (this.diagnostics) {
            try {
                this.diaWriter = fileName.equals("stdout") ? new BufferedWriter(new OutputStreamWriter(System.out)) : (fileName.equals("stderr") ? new BufferedWriter(new OutputStreamWriter(System.err)) : new BufferedWriter(new FileWriter(fileName)));
            }
            catch (IOException e) {
                throw new MaltChainedException("Could not open the diagnostic file. ", e);
            }
        }
    }

    public ClassifierGuide getGuide() {
        return this.classifierGuide;
    }

    public void setGuide(ClassifierGuide guide) {
        this.classifierGuide = guide;
    }

    public ParserConfiguration getCurrentParserConfiguration() {
        return this.currentParserConfiguration;
    }

    protected void setCurrentParserConfiguration(ParserConfiguration currentParserConfiguration) {
        this.currentParserConfiguration = currentParserConfiguration;
    }

    public ParserState getParserState() {
        return this.parserState;
    }

    protected void setParserState(ParserState parserState) {
        this.parserState = parserState;
    }

    protected AbstractParserFactory makeParserFactory() throws MaltChainedException {
        Class clazz = (Class)this.manager.getOptionValue("singlemalt", "parsing_algorithm");
        try {
            Class[] params = new Class[]{Algorithm.class};
            Object[] arguments = new Object[params.length];
            arguments[0] = this;
            Constructor constructor = clazz.getConstructor(params);
            return (AbstractParserFactory)constructor.newInstance(arguments);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException("The parser factory '" + clazz.getName() + "' cannot be initialized. ", e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException("The parser factory '" + clazz.getName() + "' cannot be initialized. ", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("The parser factory '" + clazz.getName() + "' cannot be initialized. ", e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException("The parser factory '" + clazz.getName() + "' cannot be initialized. ", e);
        }
    }

    protected void initParserState(int k) throws MaltChainedException {
        AbstractParserFactory parserFactory = this.makeParserFactory();
        ((SingleMalt)this.manager).addRegistry(parserFactory.getClass(), parserFactory);
        this.parserState = new ParserState(this, parserFactory, k);
    }

    public DependencyParserConfig getManager() {
        return this.manager;
    }

    public void setManager(DependencyParserConfig manager) {
        this.manager = manager;
    }

    protected void copyEdges(DependencyStructure source, DependencyStructure target) throws MaltChainedException {
        Iterator i$ = source.getTokenIndices().iterator();
        while (i$.hasNext()) {
            int index = (Integer)i$.next();
            TokenNode snode = source.getTokenNode(index);
            if (!snode.hasHead()) continue;
            Edge s = snode.getHeadEdge();
            Edge t = target.addDependencyEdge(s.getSource().getIndex(), s.getTarget().getIndex());
            for (SymbolTable table : s.getLabelTypes()) {
                t.addLabel(table, s.getLabelSymbol(table));
            }
        }
    }

    protected void copyEdgesForPlanar3T(DependencyStructure source, DependencyStructure target) throws MaltChainedException {
        Iterator i$ = source.getTokenIndices().iterator();
        while (i$.hasNext()) {
            int index = (Integer)i$.next();
            TokenNode snode = source.getTokenNode(index);
            if (!snode.hasHead()) continue;
            Set<DependencyNode> heads = snode.getHeads();
            for (DependencyNode head : heads) {
                SortedSet<Edge> arcos = source.getEdges();
                Element s = null;
                for (Edge arco : arcos) {
                    if (arco.getSource().getIndex() != head.getIndex() || arco.getTarget().getIndex() != snode.getIndex()) continue;
                    s = arco;
                    break;
                }
                Edge t = target.addDependencyEdge(head.getIndex(), snode.getIndex());
                for (SymbolTable table : s.getLabelTypes()) {
                    t.addLabel(table, s.getLabelSymbol(table));
                }
            }
        }
    }

    protected void copyDynamicInput(DependencyStructure source, DependencyStructure target) throws MaltChainedException {
        Iterator i$ = source.getTokenIndices().iterator();
        while (i$.hasNext()) {
            int index = (Integer)i$.next();
            TokenNode snode = source.getTokenNode(index);
            TokenNode tnode = target.getTokenNode(index);
            for (SymbolTable table : snode.getLabelTypes()) {
                if (tnode.hasLabel(table)) continue;
                tnode.addLabel(table, snode.getLabelSymbol(table));
            }
        }
    }
}

