#!/usr/bin/env perl

use strict;
use utf8;
binmode STDIN, ":encoding(utf8)";
binmode STDERR, ":encoding(utf8)";
binmode STDOUT, ":encoding(utf8)";

if ( @ARGV != 2 ) {
    print STDERR "$0 <JUMAN.katuyou> <dict>\n";
    exit;
}
&main();

sub main {
    
    my %suffixes;
    open( TEXT, $ARGV[0] ) or die print STDERR "$ARGV[0]\n";
    binmode( TEXT, ":encoding(utf8)" );
    while ( <TEXT> ) {
	chomp;
	if ( /^\((.+?)\(\((.+)\)\)\)$/ ) {
	    my $ctype = $1;
	    my @data = split( /\)\(/, $2 );
	    for my $data ( @data ) {
		my ( $cform, @suffixes ) = split( / /, $data );
		push( @{$suffixes{$ctype}{$cform}}, @suffixes );
	    }
	}else {
	    print STDERR "Error: $_\n";
	    exit;
	}
    }
    close( TEXT );

    my %pos_set;
    open( TEXT, $ARGV[1] ) or die print STDERR "$ARGV[1]\n";
    binmode( TEXT, ":encoding(utf8)" );
    while ( <TEXT> ) {
	chomp;
	my ( $surface_form, $surface_pos, $normal_form, $normal_reading, $normal_pos, $citatioin_form ) = split( /\t/, $_ );
	$pos_set{"$surface_pos"} = 1;
    }
    close( TEXT );

    for my$pos ( sort { $a cmp $b } keys %pos_set ) {
	my ( $pos1, $pos2, $ctype, $cform ) = split( /,/, $pos );
	if ( $ctype eq "*" ) {
	    print "$pos\t*\t*\n";
	}else {
	    if ( ! defined $suffixes{$ctype}{$cform} ) {
		print STDERR "$pos, $ctype, $cform\n";
	    }
	    for ( my$i = 0; $i < @{$suffixes{$ctype}{$cform}}; ++$i ) {
		print "$pos\t",$suffixes{$ctype}{$cform}[$i],"\t",$suffixes{$ctype}{"基本形"}[$i],"\n";
	    }
	}
    }
}
