/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.core.syntaxgraph.feature;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.function.FeatureFunction;
import org.maltparser.core.feature.function.Modifiable;
import org.maltparser.core.feature.value.FeatureValue;
import org.maltparser.core.feature.value.SingleFeatureValue;
import org.maltparser.core.io.dataformat.ColumnDescription;
import org.maltparser.core.symbol.SymbolTable;
import org.maltparser.core.symbol.nullvalue.NullValues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ColumnFeature
implements FeatureFunction,
Modifiable {
    protected ColumnDescription column;
    protected SingleFeatureValue featureValue = new SingleFeatureValue(this);

    @Override
    public abstract void update() throws MaltChainedException;

    @Override
    public abstract void initialize(Object[] var1) throws MaltChainedException;

    @Override
    public abstract Class<?>[] getParameterTypes();

    @Override
    public String getSymbol(int value) throws MaltChainedException {
        return this.column.getSymbolTable().getSymbolCodeToString(value);
    }

    @Override
    public int getCode(String value) throws MaltChainedException {
        return this.column.getSymbolTable().getSymbolStringToCode(value);
    }

    public ColumnDescription getColumn() {
        return this.column;
    }

    protected void setColumn(ColumnDescription column) {
        this.column = column;
    }

    @Override
    public void updateCardinality() {
        this.featureValue.setCardinality(this.column.getSymbolTable().getValueCounter());
    }

    @Override
    public void setFeatureValue(int value) throws MaltChainedException {
        if (this.column.getSymbolTable().getSymbolCodeToString(value) == null) {
            this.featureValue.setCode(value);
            this.featureValue.setKnown(this.column.getSymbolTable().getKnown(value));
            this.featureValue.setSymbol(this.column.getSymbolTable().getNullValueSymbol(NullValues.NullValueId.NO_NODE));
            this.featureValue.setNullValue(true);
        } else {
            this.featureValue.setCode(value);
            this.featureValue.setKnown(this.column.getSymbolTable().getKnown(value));
            this.featureValue.setSymbol(this.column.getSymbolTable().getSymbolCodeToString(value));
            this.featureValue.setNullValue(this.column.getSymbolTable().isNullValue(value));
        }
    }

    @Override
    public void setFeatureValue(String value) throws MaltChainedException {
        if (this.column.getSymbolTable().getSymbolStringToCode(value) < 0) {
            this.featureValue.setCode(this.column.getSymbolTable().getNullValueCode(NullValues.NullValueId.NO_NODE));
            this.featureValue.setKnown(this.column.getSymbolTable().getKnown(value));
            this.featureValue.setSymbol(value);
            this.featureValue.setNullValue(true);
        } else {
            this.featureValue.setCode(this.column.getSymbolTable().getSymbolStringToCode(value));
            this.featureValue.setKnown(this.column.getSymbolTable().getKnown(value));
            this.featureValue.setSymbol(value);
            this.featureValue.setNullValue(this.column.getSymbolTable().isNullValue(value));
        }
    }

    @Override
    public FeatureValue getFeatureValue() {
        return this.featureValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return obj.toString().equals(this.toString());
    }

    public String getColumnName() {
        return this.column.getName();
    }

    @Override
    public SymbolTable getSymbolTable() {
        return this.column.getSymbolTable();
    }

    public String toString() {
        return this.column.getName();
    }
}

