/*
 * Decompiled with CFR 0.152.
 */
package tsg.LTSG;

import java.io.File;
import java.util.Arrays;
import mstparser.DependencyParser;
import settings.Parameters;
import tsg.CFSG;
import tsg.LTSG.LTSG;
import tsg.LTSG.LTSG_EM;
import tsg.LTSG.LTSG_Entropy;
import tsg.LTSG.LTSG_Greedy;
import tsg.LTSG.LTSG_Naive;
import tsg.corpora.ConstCorpus;
import tsg.corpora.Wsj;
import util.ConstDepConverter;
import util.FileUtil;

public class LTSG_MST
extends LTSG {
    public static LTSG mainNaive(int n) {
        switch (n) {
            case 0: {
                Parameters.LTSGtype = "Collins97";
                break;
            }
            case 1: {
                Parameters.LTSGtype = "Random";
                break;
            }
            case 2: {
                Parameters.LTSGtype = "FirstLeft";
                break;
            }
            case 3: {
                Parameters.LTSGtype = "FirstRight";
            }
        }
        Parameters.outputPath = "/scratch/fsangati/RESULTS/MST/" + Parameters.LTSGtype + "/";
        LTSG_Naive Grammar2 = new LTSG_Naive();
        Grammar2.assignNaiveAnnotations();
        return Grammar2;
    }

    public static LTSG mainEM() {
        Parameters.LTSGtype = "EM";
        Parameters.outputPath = "/scratch/fsangati/RESULTS/MST/" + Parameters.LTSGtype + "/";
        Parameters.EM_initialization = "initializeUNIFORM";
        Parameters.EM_nBest = -1;
        Parameters.EM_deltaThreshold = 1.0;
        Parameters.EM_maxCycle = 10;
        Parameters.posTagConversion = true;
        Parameters.spineConversion = true;
        LTSG_EM Grammar2 = new LTSG_EM();
        Grammar2.EMalgorithm();
        return Grammar2;
    }

    public static void mainCFG() {
        Parameters.outputPath = "/scratch/fsangati/RESULTS/MST/CFG/";
        CFSG Grammar2 = new CFSG();
        boolean allowPunctuation = false;
        boolean onlyExternalChoices = false;
        Grammar2.assignHeadAnnotations(allowPunctuation, onlyExternalChoices);
    }

    public static LTSG mainGreedy() {
        Parameters.spineConversion = false;
        Parameters.removeRedundencyInSpine = false;
        Parameters.posTagConversion = true;
        Parameters.jollyConversion = false;
        Parameters.jollyInclusion = false;
        Parameters.jollyLabels = new String[]{"NP"};
        Arrays.sort(Parameters.jollyLabels);
        Parameters.greedy_punctuation = false;
        Parameters.greedy_ambiguityChoice = 2;
        Parameters.LTSGtype = "GreedyTop";
        Parameters.outputPath = "/scratch/fsangati/RESULTS/MST/" + Parameters.LTSGtype + "/";
        LTSG_Greedy Grammar2 = new LTSG_Greedy();
        Grammar2.assignGreedyAnnotations();
        return Grammar2;
    }

    public static LTSG mainEntropy() {
        Parameters.LTSGtype = "Entropy";
        Parameters.outputPath = "/scratch/fsangati/RESULTS/MST/" + Parameters.LTSGtype + "/";
        Parameters.startingHeads = "Random";
        Parameters.maxNumberOfChanges = -1;
        Parameters.orderOfChange = 2;
        Parameters.maxEntropyCycles = -1;
        Parameters.entropy_delta_threshold = 0.01;
        Parameters.spineConversion = false;
        Parameters.posTagConversion = false;
        LTSG_Entropy Grammar2 = new LTSG_Entropy();
        Grammar2.hillClimbing();
        return Grammar2;
    }

    public static void main(String[] args) {
        ConstCorpus wsj_02_11 = new ConstCorpus(new File("/scratch/fsangati/CORPUS/WSJ/MALT/penn.02-11.heads"), "noProcess");
        ConstCorpus wsj_22 = new ConstCorpus(new File("/scratch/fsangati/CORPUS/WSJ/MALT/penn.22.heads"), "noProcess");
        wsj_02_11.removeTreesLongerThan(10, Wsj.nonCountCatInLength);
        wsj_22.removeTreesLongerThan(10, Wsj.nonCountCatInLength);
        ConstCorpus complete = wsj_02_11.deepClone();
        complete.treeBank.addAll(wsj_22.treeBank);
        int wsj_02_11_size = wsj_02_11.size();
        int wsj_22_size = wsj_22.size();
        Parameters.trainingCorpus = complete;
        Parameters.corpusName = "noProcess";
        LTSG_MST.mainNaive(0);
        wsj_02_11 = complete.returnFirst(wsj_02_11_size);
        wsj_22 = complete.returnLast(wsj_22_size);
        wsj_02_11.toFile_Complete(new File(String.valueOf(Parameters.outputPath) + "penn.02-11.heads"), true);
        wsj_22.toFile_Complete(new File(String.valueOf(Parameters.outputPath) + "penn.22.heads"), true);
        boolean labels = true;
        ConstDepConverter.printMSTOutput(wsj_02_11, new File(String.valueOf(Parameters.outputPath) + "MST.02-11.lab"), false, labels);
        ConstDepConverter.printMSTOutput(wsj_22, new File(String.valueOf(Parameters.outputPath) + "MST.22.gold.lab"), false, labels);
        ConstDepConverter.printMSTOutput(wsj_22, new File(String.valueOf(Parameters.outputPath) + "MST.22.test"), true, labels);
        String[] argsTrainTestEval = new String[]{"train", "train-file:" + Parameters.outputPath + "MST.02-11.lab", "model-name:" + Parameters.outputPath + "dep.model", "training-iterations:10", "decode-type:proj", "training-k:1", "loss-type:punc", "create-forest:true", "order:1", "test", "test-file:" + Parameters.outputPath + "MST.22.test", "model-name:" + Parameters.outputPath + "dep.model", "output-file:" + Parameters.outputPath + "MST.22.parsed.lab", "decode-type:proj", "order:1", "eval", "gold-file:" + Parameters.outputPath + "MST.22.gold.lab", "output-file:" + Parameters.outputPath + "MST.22.parsed.lab"};
        try {
            DependencyParser.main((String[])argsTrainTestEval);
        }
        catch (Exception e) {
            FileUtil.handleExceptions(e);
        }
    }
}

