theory question_83_0

imports Main

begin

typedecl entity
typedecl event

consts
  Transfer :: "event ⇒ bool"
  ThermalEnergy :: "entity ⇒ bool"
  Object :: "entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Heat :: "event ⇒ bool"

(* Explanation: The transfer of thermal energy from one object to another is known as heat. *)
axiomatization where
  explanation: "∀x y e. Transfer e ∧ ThermalEnergy x ∧ Object x ∧ Object y ∧ Agent e x ∧ Patient e y ⟶ Heat e"

theorem hypothesis:
  assumes asm: "Transfer e ∧ ThermalEnergy x ∧ Object x ∧ Object y ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: The transfer of thermal energy from one object to another is known as heat. *)
  shows "Heat e"
proof -
  have "Heat e" using asm explanation_3 by blast
  then show ?thesis by simp
qed

end
