theory question_81_4
imports Main

begin

typedecl entity

consts
  Soil :: "entity ⇒ bool"
  Nonliving :: "entity ⇒ bool"
  PartOf :: "entity ⇒ entity ⇒ bool"
  ForestEnvironment :: "entity ⇒ bool"

(* Explanation 1: Soil is a kind of nonliving thing. *)
axiomatization where
  explanation_1: "∀x. Soil x ⟶ Nonliving x"

(* Explanation 2: A nonliving thing can be part of a forest environment. *)
axiomatization where
  explanation_2: "∀x. Nonliving x ⟶ (∃y. PartOf x y ∧ ForestEnvironment y)"

(* Explanation 3: Soil can be part of a forest environment. *)
axiomatization where
  explanation_3: "∀x. Soil x ⟶ (∃y. PartOf x y ∧ ForestEnvironment y)"

theorem hypothesis:
  assumes asm: "Soil x"
  (* Hypothesis: Soil is a nonliving part of a forest. *)
  shows "Nonliving x ∧ PartOf x z ∧ ForestEnvironment z"
proof -
  from asm have "Soil x" by simp
  then have "Nonliving x" using explanation_1 by blast
  then have "∃y. PartOf x y ∧ ForestEnvironment y" using explanation_2 by blast
  then obtain z where z: "PartOf x z ∧ ForestEnvironment z" by auto
  then show ?thesis using asm z by blast
qed

end
